import axios from "../../axios-config";

export const groupsGetAllMembers = (organisationId, schoolId, groupId) => {
    return async (dispatch) => {
        dispatch({
            type: "GROUP_GETTING"
        });
        let membersResponse = await axios.get(`/organisations/${organisationId}/schools/${schoolId}/groups/${groupId}/members`);
        let members = membersResponse.data.data;

        dispatch({
            type: "GROUP_GET_ALL_MEMBERS",
            payload: { members }
        });
    };
};

export const groupsGetMemberById = (userId, id) => {
    return async (dispatch) => {
        let messageResponse = await axios.get(`/users/${userId}/messages/${id}`);
        let message = messageResponse.data.data;

        dispatch({
            type: "GROUP_GET_MEMBER_BY_ID",
            payload: { message }
        });
    };
};

