import axios from "../../axios-config";

export const messagesGetAll = (userId) => {
    return async (dispatch) => {
        dispatch({
            type: "MESSAGES_GETTING"
        });
        let messagesResponse = await axios.get(`/users/${userId}/messages`);
        let messages = messagesResponse.data.data;

        dispatch({
            type: "MESSAGES_GET_ALL",
            payload: { messages }
        });
    };
};

export const messagesSendMessage = (userId, group, subject, body) => {
    return async (dispatch) => {
        dispatch({
            type: "MESSAGES_SENDING"
        });
        try {
            let messageResponse = await axios.post(`/users/${userId}/messages`, {
                subject, body, groupId: group.id, type: "group"
            });
            if (messageResponse.status !== 201 && messageResponse.status !== 200) {
                dispatch({
                    type: "MESSAGES_SEND_FAILED"
                });
            } else {
                dispatch({
                    type: "MESSAGES_SENT",
                });
            }
        } catch {
            dispatch({
                type: "MESSAGES_SEND_FAILED"
            });
        }
    };
};

export const messagesGetById = (userId, id) => {
    return async (dispatch) => {
        let messageResponse = await axios.get(`/users/${userId}/messages/${id}`);
        let message = messageResponse.data.data;

        dispatch({
            type: "MESSAGES_GET_BY_ID",
            payload: { message }
        });
    };
};

