import axios from "../../axios-config";

export const personalUpdateData = (userId, person) => {
    return async (dispatch) => {
        dispatch({
            type: "PERSONAL_UPDATING"
        });

        let personInfo = await axios.put(`/users/${userId}`, { person });

        if (personInfo.status !== 200) {
            console.error(personInfo);
            return dispatch({
                type: "PERSONAL_SET_ERROR",
                payload: personInfo
            });
        }

        return dispatch({
            type: "PERSONAL_UPDATED"
        });
    };
};