import axios from "../../axios-config";

export const pollsSend = (userId, pollId, answers) => {
    return async (dispatch) => {
        dispatch({ type: "POLLS_SENDING" });
        try {
            let feedbackResponse = await axios.post(`/users/${userId}/polls/${pollId}/answers`, { answers });

            if (feedbackResponse.status !== 201 && feedbackResponse.status !== 200) {
                dispatch({ type: "POLLS_SEND_FAILED" });
            } else {
                dispatch({ type: "POLLS_SENT", payload: true });
                dispatch(pollsGet(userId));
            }
        } catch {
            dispatch({
                type: "POLLS_SEND_FAILED"
            });
        }
    };
};


export const pollsGet = (userId) => {
    return async (dispatch) => {
        dispatch({ type: "POLLS_GETTING" });
        try {
            let feedbackResponse = await axios.get(`/users/${userId}/polls`);
            if (feedbackResponse.status !== 200) {
                dispatch({
                    type: "POLLS_GET_FAILED"
                });
            } else {
                dispatch({
                    type: "POLLS_RECEIVED",
                    payload: feedbackResponse.data.data
                });
            }
        } catch {
            dispatch({
                type: "POLLS_GET_FAILED"
            });
        }
    };
};

export const pollsGetById = (userId, pollId) => {
    return async (dispatch) => {
        dispatch({ type: "POLLS_GETTING" });
        try {
            let feedbackResponse = await axios.get(`/users/${userId}/polls/${pollId}`);
            if (feedbackResponse.status !== 200) {
                dispatch({
                    type: "POLLS_GET_FAILED"
                });
            } else {
                dispatch({
                    type: "POLL_RECEIVED",
                    payload: feedbackResponse.data.data
                });
            }
        } catch {
            dispatch({
                type: "POLLS_GET_FAILED"
            });
        }
    };
};

