const INITIAL_STATE = {
	loading: false,
	authToken: null,
	user: null,
	permissions: null,
	error: null,
    isPublicAccount: false
};

const reducer = (state = INITIAL_STATE, action) => {
	switch (action.type) {
		case "AUTH_REQUEST":
			return {
				...state,
				loading: true,
				authToken: action.payload.authToken,
				user: null,
				permissions: null
			};
		case "AUTH_FAILED":
			return {
				...state,
				loading: false,
				authToken: null,
				user: null,
				permissions: null
			};
		case "AUTH_SUCCESS":
			return {
				...state,
				loading: false,
				authToken: action.payload.authToken,
				user: action.payload.user,
				permissions: action.payload.permissions,
                isPublicAccount: action.payload.user.username === "tst-0005"
			};
		case "AUTH_LOGGING_IN":
			return {
				...state,
				loading: true,
				error: null
			};
		case "AUTH_LOGIN_FAILED":
			return {
				...state,
				loading: false,
				error: action.payload
			};
		case "AUTH_LOGIN_SUCCESS":
			const { authToken, user, permissions } = action.payload;
			return {
				...state,
				loading: false,
                error: null,
				authToken,
				user,
				permissions,
                isPublicAccount: action.payload.user.username === "tst-0005"
			};
		case "AUTH_LOGGING_OUT":
			return {
				...state,
				loading: true
			};
		case "AUTH_LOGOUT_SUCCESS":
			return {
				...state,
				loading: false,
				authToken: null,
				user: null,
				permissions: null
			};
		default:
			return {
				...state
			};
	}
};

export default reducer;
