const INITIAL_STATE = {
  list: [],
  sponsors: [],
  activeOrganisationSlug: null,
  shownCompany: null,
  loading: false,
};

const reducer = (state = INITIAL_STATE, action) => {
  switch (action.type) {
    case 'COMPANIES_GETTING':
      return {
        ...state,
        loading: true,
      };
    case 'COMPANIES_SET_ALL':
      return {
        ...state,
        list: action.payload.companies,
        sponsors: action.payload.sponsors,
        loading: false,
      };
    case 'ORGANISATIONS_SET_ACTIVE':
      return {
        ...state,
        activeOrganisationSlug: action.payload.organisationSlug,
      };
    case 'COMPANIES_SET_SINGLE':
      let newState = {...state};
      newState.list[
        newState.list.findIndex((c) => c.id === action.payload.id)
      ] = action.payload.company;
      newState.shownCompany = action.payload.company;
      return newState;
    case 'COMPANIES_SET_SHOWN':
      return {
        ...state,
        shownCompany: action.payload.company,
      };
    default:
      return {
        ...state,
      };
  }
};

export default reducer;
