const INITIAL_STATE = {
    members: [],
    lastLoaded: null,
    loading: false
};

const reducer = (state = INITIAL_STATE, action) => {
    switch (action.type) {
        case "GROUP_GETTING":
            return {
                ...state,
                loading: true
            };
        case "GROUP_GET_ALL_MEMBERS":
            return {
                ...state,
                members: action.payload.members,
                loading: false
            };
        case "GROUP_GET_MEMBER_BY_ID":
            const newState = {...state};
            newState.members[newState.members.findIndex(m => m.id === action.payload.member.id)] = action.payload.member;
            newState.lastLoaded = action.payload.member.id;
            return newState;
        default:
            return {
                ...state
            };
    }
};

export default reducer;
