const INITIAL_STATE = {
    list: [],
    lastLoaded: null,
    loading: false,
    sending: false,
    error: null
};

const reducer = (state = INITIAL_STATE, action) => {
    switch (action.type) {
        case "MESSAGES_GETTING":
            return {
                ...state,
                loading: true,
                error: null
            };
        case "MESSAGES_SENDING":
            return {
                ...state,
                sending: true,
                error: null
            };
        case "MESSAGES_SENT":
            return {
                ...state,
                sending: false,
                error: null
            };
        case "MESSAGES_SEND_FAILED":
            return {
                ...state,
                sending: false,
                error: "Het versturen van berichten is nog niet mogelijk."
            };
        case "MESSAGES_GET_ALL":
            return {
                ...state,
                list: action.payload.messages,
                loading: false,
                error: null
            };
        case "MESSAGES_GET_BY_ID":
            const newState = {...state};
            newState.list[newState.list.findIndex(m => m.id === action.payload.message.id)] = action.payload.message;
            newState.lastLoaded = action.payload.message.id;
            return newState;
        default:
            return {
                ...state
            };
    }
};

export default reducer;
