const INITIAL_STATE = {
    error: null,
    loading: false,
};

const reducer = (state = INITIAL_STATE, action) => {
    switch (action.type) {
        case "PERSONAL_UPDATING":
            return {
                ...state,
                error: null,
                loading: true
            };
        case "PERSONAL_UPDATED":
            return {
                ...state,
                error: null,
                loading: false
            };
        case "PERSONAL_SET_ERROR":
            return {
                ...state,
                error: action.payload,
                loading: false
            };
        default:
            return {
                ...state
            };
    }
};

export default reducer;
