const INITIAL_STATE = {
    list: [],
    lastLoaded: null,
    loading: false,
    error: null,
    submitting: false,
    success: null
};

const reducer = (state = INITIAL_STATE, action) => {
    switch (action.type) {
        case "POLLS_GETTING":
            return {
                ...state,
                loading: true,
                error: null,
                success: null
            };
        case "POLLS_RECEIVED":
            return {
                ...state,
                loading: false,
                error: null,
                list: action.payload,
                submitting: false,
                success: null
            };
        case "POLL_RECEIVED": {
            let index = state.list.findIndex(p => p.id === action.payload.id);
            if (index === -1) {
                index = 0;
            }
            const list = state.list;
            list[index] = action.payload;
            return {
                ...state,
                loading: false,
                error: null,
                lastLoaded: action.payload,
                list
            };
        }
        case "POLLS_GET_FAILED":
            return {
                ...state,
                loading: false,
                error: "Er ging iets mis bij het ophalen van de feedback mogelijkheden van je feedback, probeer het later nog eens."
            };
        case "POLLS_SENDING":
            return {
                ...state,
                submitting:  true,
                error: null
            };
        case "POLLS_SENT":
            return {
                ...state,
                success: true,
                error: null
            };
        case "POLLS_SEND_FAILED":
            return {
                ...state,
                submitting: false,
                error: "Er ging iets mis bij het versturen van je feedback, probeer het later nog eens."
            };
        default:
            return {
                ...state
            };
    }
};

export default reducer;
