/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.text;

import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;

public class GVTACIImpl
implements GVTAttributedCharacterIterator {
    private String simpleString;
    private Set allAttributes;
    private ArrayList mapList;
    private static int START_RUN = 2;
    private static int END_RUN = 3;
    private static int MID_RUN = 1;
    private static int SINGLETON = 0;
    private int[] charInRun;
    private CharacterIterator iter = null;
    private int currentIndex = -1;

    public GVTACIImpl() {
        this.simpleString = "";
        this.buildAttributeTables();
    }

    public GVTACIImpl(AttributedCharacterIterator attributedCharacterIterator) {
        this.buildAttributeTables(attributedCharacterIterator);
    }

    @Override
    public void setString(String string) {
        this.simpleString = string;
        this.iter = new StringCharacterIterator(this.simpleString);
        this.buildAttributeTables();
    }

    @Override
    public void setString(AttributedString attributedString) {
        this.iter = attributedString.getIterator();
        this.buildAttributeTables((AttributedCharacterIterator)this.iter);
    }

    @Override
    public void setAttributeArray(GVTAttributedCharacterIterator.TextAttribute textAttribute, Object[] objectArray, int n, int n2) {
        n = Math.max(n, 0);
        n2 = Math.min(n2, this.simpleString.length());
        if (this.charInRun[n] == END_RUN) {
            this.charInRun[n - 1] = this.charInRun[n - 1] == MID_RUN ? END_RUN : SINGLETON;
        }
        if (this.charInRun[n2 + 1] == END_RUN) {
            this.charInRun[n2 + 1] = SINGLETON;
        } else if (this.charInRun[n2 + 1] == MID_RUN) {
            this.charInRun[n2 + 1] = START_RUN;
        }
        for (int i = n; i <= n2; ++i) {
            this.charInRun[i] = SINGLETON;
            int n3 = Math.min(i, objectArray.length - 1);
            ((Map)this.mapList.get(i)).put(textAttribute, objectArray[n3]);
        }
    }

    @Override
    public Set getAllAttributeKeys() {
        return this.allAttributes;
    }

    @Override
    public Object getAttribute(AttributedCharacterIterator.Attribute attribute) {
        return this.getAttributes().get(attribute);
    }

    @Override
    public Map getAttributes() {
        return (Map)this.mapList.get(this.currentIndex);
    }

    @Override
    public int getRunLimit() {
        int n = this.currentIndex;
        while (this.charInRun[++n] == MID_RUN) {
        }
        return n;
    }

    @Override
    public int getRunLimit(AttributedCharacterIterator.Attribute attribute) {
        int n = this.currentIndex;
        Object v = this.getAttributes().get(attribute);
        if (v == null) {
            while (((Map)this.mapList.get(++n)).get(attribute) == null) {
            }
        } else {
            while (v.equals(((Map)this.mapList.get(++n)).get(attribute))) {
            }
        }
        return n;
    }

    @Override
    public int getRunLimit(Set set) {
        int n = this.currentIndex;
        while (((Object)set).equals(this.mapList.get(++n))) {
        }
        return n;
    }

    @Override
    public int getRunStart() {
        int n = this.currentIndex;
        while (this.charInRun[n] == MID_RUN) {
            --n;
        }
        return n;
    }

    @Override
    public int getRunStart(AttributedCharacterIterator.Attribute attribute) {
        int n = this.currentIndex - 1;
        Object v = this.getAttributes().get(attribute);
        try {
            if (v == null) {
                while (((Map)this.mapList.get(n - 1)).get(attribute) == null) {
                    --n;
                }
            } else {
                while (v.equals(((Map)this.mapList.get(n - 1)).get(attribute))) {
                    --n;
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return n;
    }

    @Override
    public int getRunStart(Set set) {
        int n = this.currentIndex;
        try {
            while (((Object)set).equals(this.mapList.get(n - 1))) {
                --n;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return n;
    }

    @Override
    public Object clone() {
        GVTACIImpl gVTACIImpl = new GVTACIImpl(this);
        return gVTACIImpl;
    }

    @Override
    public char current() {
        return this.iter.current();
    }

    @Override
    public char first() {
        return this.iter.first();
    }

    @Override
    public int getBeginIndex() {
        return this.iter.getBeginIndex();
    }

    @Override
    public int getEndIndex() {
        return this.iter.getEndIndex();
    }

    @Override
    public int getIndex() {
        return this.iter.getIndex();
    }

    @Override
    public char last() {
        return this.iter.last();
    }

    @Override
    public char next() {
        return this.iter.next();
    }

    @Override
    public char previous() {
        return this.iter.previous();
    }

    @Override
    public char setIndex(int n) {
        return this.iter.setIndex(n);
    }

    private void buildAttributeTables() {
        this.allAttributes = new HashSet();
        this.mapList = new ArrayList(this.simpleString.length());
        this.charInRun = new int[this.simpleString.length()];
        for (int i = 0; i < this.charInRun.length; ++i) {
            this.charInRun[i] = SINGLETON;
            this.mapList.set(i, new HashMap());
        }
    }

    private void buildAttributeTables(AttributedCharacterIterator attributedCharacterIterator) {
        this.allAttributes = attributedCharacterIterator.getAllAttributeKeys();
        int n = attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex();
        this.mapList = new ArrayList(n);
        this.charInRun = new int[n];
        char c = attributedCharacterIterator.first();
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = c;
            this.charInRun[i] = SINGLETON;
            this.mapList.set(i, new HashMap<AttributedCharacterIterator.Attribute, Object>(attributedCharacterIterator.getAttributes()));
            c = attributedCharacterIterator.next();
        }
        this.simpleString = new String(cArray);
    }

    public class TransformAttributeFilter
    implements GVTAttributedCharacterIterator.AttributeFilter {
        @Override
        public AttributedCharacterIterator mutateAttributes(AttributedCharacterIterator attributedCharacterIterator) {
            return attributedCharacterIterator;
        }
    }
}

