;
; AutoIt Version: 3.0
; Language:       English
; Platform:       WinXP/2003/Vista
; Author:         Marcel Jordaan (mjordaan@rldautomation.eu)
;
; Script Function:
;   Starts the FactoryLink webclient using graph.exe, and accepts the the same
;   commandline parameters as graph.exe.
;   This script will start the weblcient and close all popup messageboxes repor-
;   ting errors, normally weblcient will close after accepting popup messages!
;   Note: the path variable should be set to the bin-directory where webclient is
;   installed
#NoTrayIcon
; Usage:
;   Calling this script in cmd or batch file makes it possible to auto-close webclient
;   after an error, and restart the same or an alternative weblcient connection.
#include <GUIConstantsEx.au3>
#include <WindowsConstants.au3>
#include <SendMessage.au3>
#include <IE.au3>
#Include <WinAPI.au3>
#Include <Constants.au3>

; debug function for use with Sysinternals DebugViewer
Func dbg($msg)
  DllCall("kernel32.dll", "none", "OutputDebugString", "str", $msg)
EndFunc ;==>dbg

; function to find window handle from process id
Func _GetHwndFromPID($PID)

  $hWnd = 0
  $stPID = DllStructCreate("int")

  Do
    $winlist2 = WinList()

    For $i = 1 To $winlist2[0][0]

      If $winlist2[$i][0] <> "" Then

        DllCall("user32.dll", "int", "GetWindowThreadProcessId", "hwnd", $winlist2[$i][1], "ptr", DllStructGetPtr($stPID))

        If DllStructGetData($stPID, 1) = $PID Then
          $hWnd = $winlist2[$i][1]
          ExitLoop
        EndIf
      EndIf
    Next

    Sleep(10)

  Until $hWnd <> 0

  Return $hWnd
EndFunc ;==>_GetHwndFromPID

;==============================================================================
; MyExitfunction
;==============================================================================
Func MyExitFunction()

  ;first delete any existing File
  FileDelete(@WorkingDir & "\ExitMethod.flg")
  FileWriteLine(@WorkingDir & "\ExitMethod.flg", @ExitMethod)
  ;FileWriteLine(@WorkingDir & "\ExitMethod.flg", $GraphPID)
EndFunc

;==============================================================================
; Main flweb
;==============================================================================

;define and register exit function
;OnAutoItExitRegister( "MyexitFunction")

;initialize the command line parameter string
$params = ""
$inifile = @ScriptDir & "/flweb.ini"

;dbg( "Webclient: INI file = " & $inifile)

;Get the commandline and build the parameter list for webclient
For $i = 1 to $CmdLine[0] step 1

  $params = $params & " " & $CmdLine[$i]
Next

;Overrule command line for debug purposes: REMOVE THIS LINE BEFORE PRODUCTION
;$params = " -ni4,-m30,-hT10S1:6096"

;now start checking if graph is showing an error message box before quitting
;Wait for webclient toe report a failure
;webclient should be running, if not quit
$startup = -1
$webclient = -1
$GraphhWnd = 0

local $serverx[2]

while (($webclient <> 0) or ($startup <> 0))

  ;dbg( "Webclient: $webclient=" & $webclient & "; $startup=" & $startup)

  if ($startup <> 0) then

    ;if there is a command line, ignore settings in the ini-file
    ;settings ignored are arguments and server definitions, mark
    ;that from the comand line only one server can be defined!
    if ($params == "") then

      ;read arguments and server definitions
      $params = IniRead( $inifile, "WEBCLIENT", "WEBCLIENT_ARGUMENTS" , "")
      $serverx[0] = "-h" & IniRead( $inifile, "WEBCLIENT", "WEBCLIENT_SERVER1" , "")
      $serverx[1] = "-h" & IniRead( $inifile, "WEBCLIENT", "WEBCLIENT_SERVER2" , "")

      ;active server is server1
      $server = 0

      if ($params <> "") then
        $params = $params & ","
      else
        $params = " "
      endif
    endif

    ;Read settings from flweb.ini file in current working directory
    $WebCLientDir = IniRead( $inifile, "WEBCLIENT", "WEBCLIENT_DIR" , "C:\Program Files\Siemens\FactoryLink\Client\WebClient\Bin")
    $WebCLientClass = IniRead( $inifile, "WEBCLIENT", "WINCLASS" , "dispclass")
    $WebCLientWin = IniRead( $inifile, "WEBCLIENT", "MAINWIN_NAME" , "APPLICATION")
    $WebCLientStyle = IniRead( $inifile, "WEBCLIENT", "MAINWIN_STYLE" , "0x94000000")
    $WebCLientWinChange = Int( IniRead( $inifile, "WEBCLIENT", "MAINWIN_CHANGE" , "0"))
    $FullScreenChange = Int( IniRead( $inifile, "WEBCLIENT", "FULLSCREEN_CHANGE" , "0x94000000"))
    $FullScreenStyle = IniRead( $inifile, "WEBCLIENT", "FULLSCREEN_STYLE" , "0x94000000")

    $WebCLientAlwaysActive = Int( IniRead( $inifile, "WEBCLIENT", "WEBCLIENT_ALWAYS_ACTIVE" , "0"))

    $MainWin_X = Int( IniRead( $inifile, "WEBCLIENT", "MAINWIN_X" , "0"))
    $MainWin_Y = Int( IniRead( $inifile, "WEBCLIENT", "MAINWIN_Y" , "0"))
    $MainWin_Width = Int( IniRead( $inifile, "WEBCLIENT", "MAINWIN_WIDTH" , "0"))
    $MainWin_Height = Int( IniRead( $inifile, "WEBCLIENT", "MAINWIN_HEIGHT" , "0"))

	$ShowMyIcon = Int( IniRead( $inifile, "PROGRAM", "HIDE_ICON" , "1"))
	AutoItSetOption( "TrayIconHide", $ShowMyIcon)

    ;debug info for ini file parameters
    ;dbg( "Webclient: INI file:  WEBCLIENT_DIR = " & $WebCLientDir)
    ;dbg( "Webclient: INI file:  MAINWIN_CHANGE = " & $WebCLientWinChange)
    ;dbg( "Webclient: INI file: WINCLASS = " & $WebCLientClass)
    ;dbg( "Webclient: INI file: MAINWIN_NAME = " & $WebCLientWin)
    ;dbg( "Webclient: INI file: MAINWIN_STYLE = " & $WebCLientStyle)
    ;dbg( "Webclient: INI file:  FULLSCREEN_CHANGE = " & $FullScreenChange)
    ;dbg( "Webclient: INI file: FULLSCREEN_STYLE = " & $FullScreenStyle)

    ;read and set the hot keys
    $HotKeyMaximize = IniRead( $inifile, "HOTKEYS", "MAXIMIZE_KEY" , "")
    ;dbg( "Webclient: HotKey Maximize = " & $HotKeyMaximize)
	$idx = 0
    If StringLen( $HotKeyMaximize) > 0 Then
      HotKeySet( $HotKeyMaximize, "Maximize")
    EndIf

    $HotKeyExit = IniRead( $inifile, "HOTKEYS", "WCEXIT_KEY" , "")
    ;dbg( "Webclient: HotKey Exit = " & $HotKeyExit)
    If StringLen( $HotKeyExit) > 0 Then
      HotKeySet( $HotKeyExit, "WcExit")
      ;dbg( "Webclient: Hotkey for exit set")
    EndIf

    ;start webclient with parameters
	;dbg( "Webclient: " & $params & $serverx[$server])
    $GraphPID = Run( $WebCLientDir & "/graph.exe" & " " & $params & $serverx[$server])

    if ($server == 0) Then

      If ( $serverx[1] <> "-h") > 0 Then
	      $server = 1
	    EndIf
    Else
	  $server = 0
    EndIf

    ;get the PID for the webclient task
    $webclient = $GraphPID ;ProcessWait( "graph.exe", 20)

    If $webclient == 0 Then

      ;only report with message box if defined in ini file
      $ReportExit = IniRead( $inifile, "WEBCLIENT", "ERROREXIT" , 0)

      If $ReportExit Then
        MsgBox(0, "FactoryLink webclient", "'Graph' did not start. Bye!")

        ;Exit the script
        Exit
      EndIf
    EndIf

    $startup = 0

    ;Start monitoring our process
    ShellExecute( @WorkingDir & "\AutoItMon.exe", @AutoItPID & " " & $GraphPID)
  EndIf

  ;sleep( 10000)

  ;get the PID for graph.exe, so we can check if the process is still running
  ;$webclient = ProcessExists( "graph.exe")
  ;dbg( "Webclient: PID for graph = " & $webclient)

  ;now start checking if graph is showing an error message box before quitting
  ;Wait for webclient toe report a failure
  ;webclient should be running, if not quit
  ;while ($webclient <> 0)

  ;do have to change the appearance of the main window?
  if ($WebCLientWinChange <> 0) or ($FullScreenChange <> 0) Then

    ;dbg( "Webclient: Upfdating style for main window webclient")

    ;find the handle with the main window name and class
	$GraphhWnd = _GetHwndFromPID( $GraphPID)
	dbg( "Webclient: _GetHwndFromPID, window handle = " & $GraphhWnd)
	$GraphState = WinGetState( $GraphhWnd)
	dbg( "Webclient: WinGetState, window state = " & $GraphState)

    ;$GraphhWnd = _WinAPI_FindWindow( $WebCLientClass, $WebCLientWin)
	;dbg( "Webclient: _WinAPI_FindWindow, window handle = " & $GraphhWnd)

    ;$i = 0

    ;wait for the main window to show
    ;While ($GraphhWnd <= 0)

      ;Sleep( 10)

      ;$GraphhWnd = _WinAPI_FindWindow( $WebCLientClass, $WebCLientWin)

      ;$i += 1
      ;if $i > 200 Then

        ;if took to long to find the main window, just continue
      ;  $GraphhWnd = 1
      ;EndIf
    ;WEnd
    if ($GraphState >= 7) then

      if ($WebCLientWinChange <> 0) then

        ;dbg( "Webclient: wHnd graph = " & $GraphhWnd)

        ;change the window style accoriding to ini file settings
        SetWindow( $WebCLientStyle, $GraphhWnd)

        ;we have changed the appeareance, do this only once
        $WebCLientWinChange = 0
        $FullScreenChange = 0
      else

        ;change the window style accoriding to ini file settings
        SetWindow( $FullScreenStyle, $GraphhWnd)

        ;we have changed the appeareance, do this only once
        $WebCLientWinChange = 0
        $FullScreenChange = 0
      endif
    endif
  EndIf

  ;webclient uses standard messageboxes to report errors, other programs use the same
  ;class names for the standard messageboxes.
  ;if we find a standard message box, check if it is owned by webclient
  $var = WinList("[CLASS:#32770]")
  ;$array[0][0] = Number of windows returned
  ;$array[1][0] = 1st window title
  ;$array[1][1] = 1st window handle (HWND)
  ;$array[2][0] = 2nd window title
  ;$array[2][1] = 2nd window handle (HWND)
  $keepgoing = 0

  ;dbg( "Msgbox: " & $var[0][0])

  ;loop through all the standard messageboxes
  For $i = 1 to $var[0][0] step 1

    ;check if the messagebox is owned by webclient, if not just ignore
  $PidMsgBox = WinGetProcess($var[$i][1])

    If $webclient == $PidMsgBox Then

      dbg( "Webclient: Number of matches = " & $var[0][0] & "; counter = " & $i)
      dbg( "Webclient: PID graph.exe: " & $webclient)
      dbg( "Webclient: PID message box: " & $PidMsgBox)
      dbg( "Webclient: Handle message box: " & $var[$i][1])
	  dbg( "Webclient: title message box: " & $var[$i][0])

      ;messagebox is owned by webclient, give user 2.5 seconds to read....
      Sleep( 2500)

      ;close the message box
      WinClose($var[$i][1])
      ;dbg( "Webclient: Closed error message box from graph.exe: " & $var[$i][0])

      ;for severe erros webclient shuts down, and we will exit our while loop
  	  ;$startup = -1
	  ;Sleep( 1000)
      ;$webclient = ProcessExists( "graph.exe")
      ;if ($webclient == 0) then
      ;  ProcessClose( $webclient)
	    ;$startup = -1
      ;endif
    EndIf
  Next

  ;do not use 100% CPU power, just go to sleep for tenth a second
  Sleep( 100)

  ;we are finished if webclient is shutdown or has ended after error
  $webclient = ProcessExists( "graph.exe")
  if ($webclient == 0) and ($WebCLientAlwaysActive <> 0) then
    $startup = -1
  endif
WEnd
; Finished!

;Leave the script
WcExit()
Exit

;=======================================================================================
; FUNCTION definitions
;=======================================================================================
Func Maximize()
  Local Const $SC_MAXIMIZE = 0xF030, $SC_RESTORE = 0xF120
  Local $sState

  $GraphhWnd = _GetHwndFromPID( $GraphPID)
  dbg( "Webclient: _GetHwndFromPID, window handle = " & $GraphhWnd)

  if ($GraphhWnd == 0) Then
    Return
  EndIf

  If BitAND(WinGetState($GraphhWnd), 32) = 0 Then ; Not Maximised
    $sState = $SC_MAXIMIZE
    SetWindow( 0, $GraphhWnd)
  Else
    $sState = $SC_RESTORE
    SetWindow( $WebCLientStyle, $GraphhWnd)
  EndIf

  Return _SendMessage($GraphhWnd, $WM_SYSCOMMAND, $sState)
EndFunc   ;==>Maximize


Func WcExit()
  ;dbg( "Webclient: Hotkey for exit script")
  ProcessClose( $webclient)
  Exit
EndFunc ;==>WcExit

Func SetWindow( $WindowStyle, $hWnd)

  $GraphhWnd = _GetHwndFromPID( $GraphPID)
  dbg( "Webclient: _GetHwndFromPID, window handle = " & $GraphhWnd)

  $wpLong = _WinAPI_SetWindowLong($GraphhWnd, $GWL_STYLE, $WindowStyle)
  dbg( "Webclient: _WinAPI_SetWindowLong returned = " & $wpLong)
  if ($hWnd > 0) Then

    if ($MainWin_X == 0) and ($MainWin_Y == 0) and ($MainWin_Width == 0) and ($MainWin_Height == 0) then
      _WinAPI_SetWindowPos($hWnd,0,0,0,0,0,$SWP_FRAMECHANGED+$SWP_NOMOVE+$SWP_NOSIZE)
    else
      _WinAPI_SetWindowPos($hWnd,0,$MainWin_X,$MainWin_Y,$MainWin_Width,$MainWin_Height,$SWP_FRAMECHANGED)
    endif

    ;redraw frame and client area
    _WinAPI_RedrawWindow($hWnd)
  EndIf
EndFunc
