<?php

/*
 * This file is part of the Kimai time-tracking app.
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace App\Tests\Entity;

use App\Entity\Customer;
use App\Entity\CustomerComment;

/**
 * @covers \App\Entity\CustomerComment
 * @covers \App\Entity\CommentTableTypeTrait
 */
class CustomerCommentTest extends AbstractCommentEntityTest
{
    protected function getEntity(): CustomerComment
    {
        return new CustomerComment(new Customer('foo'));
    }

    public function testEntitySpecificMethods()
    {
        $sut = $this->getEntity();
        self::assertNotNull($sut->getCustomer());
    }
}
