<?php
/**
 * This file is part of
 * Kimai - Open Source Time Tracking // https://www.kimai.org
 * (c) Kimai-Development-Team since 2006
 *
 * Kimai is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; Version 3, 29 June 2007
 *
 * Kimai is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Kimai; If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * english
 */
return [
    "countryCode" => "en-EN",
    "preferences" => "Preferences",
    "total" => "Total",
    "monatzeit" => "Month",
    "heute" => "today",
    "gestern" => "yesterday",
    "autoOn" => "Auto On",
    "autoOff" => "Auto Off",
    "datum" => "Date",
    "in" => "In",
    "out" => "Out",
    "time" => "h:m",
    "timelabel" => "Time",
    "starttime" => "start time",
    "DateTimeNotInFuture" => "The day and time must not be in the future.",
    "durationlabel" => "Duration",
    "customer" => "Customer",
    "project" => "Project",
    "activity" => "Activity",
    "customers" => "Customers",
    "projects" => "Projects",
    "activities" => "Activities",
    "admin" => "Admin",
    "rowlimit" => "max. rows",
    "breiteZeitspalte" => "width time column",
    "breiteUhrspalte" => "width clock column",
    "breiteDatumspalte" => "width date column",
    "recommended" => "recommended",
    "submit" => "OK",
    "cancel" => "Cancel",
    "edit" => "Edit Entry",
    "editNote" => "Edit note",
    "note" => "Note",
    "close" => "close",
    "construction" => "under construction...",
    "about" => "About Kimai",
    "hours" => "hours",
    "mins" => "minutes",
    "secs" => "seconds",
    "skin" => "Skin",
    "erase" => "Erase Entry",
    "new_customer" => "add customer",
    "new_project" => "add project",
    "new_activity" => "add activity",
    "day_summary" => "Time summary",
    "plzChoose" => "please select",
    "recordAgain" => "Record this recording again",
    "comment" => "Comment",
    "location" => "Location",
    "trackingNumber" => "Tracking Number",
    "cookiewarning" => "Turn Cookies on before you proceed.",
    "JSwarning" => "JavaScript must be active.",
    "designation" => "Description",
    "banned" => "Banned (Account locked)",
    "tooManyLogins" => "Too many wrong logins - user suspended.",
    "accessDenied" => "Access denied!",
    "wrongPass" => "Wrong Username and/or Password",
    "tryAgain" => "Try again / forgot password?",
    "back" => "Back to login window",
    "bye" => "Bye!",
    "login" => "Login",
    "logout" => "Logout",
    "loggedon" => "Logged on as user:",
    "username" => "Username",
    "password" => "Password",
    "newPassword" => "New Password",
    "retypePassword" => "retype password",
    "passwordsDontMatch" => "The passwords you've entered don't match.",
    "passwordTooShort" => "The password doesn't have at least 5 characters.",
    "forgotPassword" => "Forgot my password",
    "passwordReset" => [
        "button" => "Reset password",
        "notSupported" => "The current authentication plugin doesn't support resetting the password.",
        "instructions" => "Enter your username and an email containing a link will be sent to the associated email address. There will be no indication if your username is correct so make sure to enter it correctly!",
        "mailSubject" => "Kimai - Password reset",
        "mailMessage" => "This is an automatically generated mail to reset your password at Kimai. Please open the following address in your browser:\n%{URL}",
        "mailConfirmation" => "An email has been sent to the associated email address. Please follow the instructions provided in that email. If no email address is associated with this username you won't receive an email and need to contact your administrator.",
        "returnToLogin" => "return to login page",
        "invalidKey" => "The security key doesn't match the key sent by email. Make sure the complete URL is opened by your browser.",
        "success" => "Your password has been changed.",
    ],
    "minLength" => "min. 5 characters!",
    "update" => "The database structure of the installed Kimai version has to be updated.<br />We recommend to backup your recorded data to make sure no data gets lost<br />during the update process.",
    "updateNow" => "Update the database now!",
    "stop" => "Stop!",
    "start" => "Start!",
    "setTimeframe" => "set timeframe",
    "now" => "now",
    "specify" => "specify list",
    "add" => "add",
    "addNote" => "Add a note",
    "running" => "Running...",
    "company" => "Company",

    "vat" => "VAT",
    "contactPerson" => "Contact person",

    "street" => "Street",
    "zipcode" => "Zipcode",
    "city" => "City",
    "country" => "Country",
    "telephon" => "Phone",
    "fax" => "Fax",
    "mobilephone" => "Cell",
    "mail" => "E-Mail",
    "homepage" => "Internet",
    "users" => "Users",
    "name" => "Name",
    "alias" => "Nickname",
    "adduser" => "Add user",
    "addgroup" => "Add group",
    "group" => "Group",
    "groups" => "Groups",
    "advanced" => "Advanced",
    "database" => "Database",
    "options" => "Options",
    "status" => "Status",
    "globalRole" => "Global role",
    "addGlobalRole" => "Add global role",
    "editGlobalRole" => "Edit global role",
    "deleteGlobalRole" => "Delete global role",
    "globalRoles" => "Global roles",
    "membershipRole" => "Membership role",
    "addMembershipRole" => "Add membership role",
    "editMembershipRole" => "Edit membership role",
    "deleteMembershipRole" => "Delete membership role",
    "membershipRoles" => "Membership roles",
    "rolename" => "Role name",
    "editstatus" => "Edit status",
    "new_status" => "Add status",
    "description" => "Description",
    "adminmail" => "email address of administrator",
    "logintries" => "number of false logins before user gets banned",
    "bantime" => "login ban time in seconds",
    "defaultGroup" => "Default (0)",
    "user" => "Regular user",
    "editUser" => "Edit user",
    "editGroup" => "Edit group",
    "delete_group" => "delete group",
    "delete_project" => "delete project",
    "delete_customer" => "delete customer",
    "delete_activity" => "delete activity",
    "delete_status" => "delete status",
    "switchUser" => "Switch to this user",
    "backupUser" => "Make backup of this user",
    "mailUser" => "Send email to this user",
    "deleteUser" => "Delete this user",
    "restoreAccount" => "Restore account",
    "bannedUser" => "Banned user - click to reactivate",
    "activeAccount" => "Active user - click to ban",
    "members" => "Members",
    "nopasswordset" => "No password set!",
    "nopassword" => "No password",
    "noItems" => "no Entries",
    "DBname" => "Name of database",
    "DBbackup" => "Database Backup Utility",
    "DButf8" => "UTF-8 activated",
    "autoselection" => "Autoselection",
    "openAfterRecorded" => "Open entry after the recording was stopped",
    "quickdelete" => "Option to delete entries from within tables",
    "quickdeleteHide" => "No",
    "quickdeleteShow" => "Yes, without confirmation dialog",
    "quickdeleteShowConfirm" => "Yes, with confirmation dialog",
    "tools" => "Tools",
    "print" => "Print",
    "save" => "Save",
    "export" => "Export",
    "groupname" => "Group name",
    "help" => "Help",
    "select" => "Select",
    "hidedeletedusers" => "Hide deleted users",
    "showdeletedusers" => "Show deleted users",
    "month" => "Month",
    "day" => "Day",
    "year" => "Year",
    "lang" => "Language",
    "ac" => "Automatically continued entry.",
    "ac_error" => "Automatically continued entry with error (timespan too long).",
    "refundable_long" => "Refundable (to employee)",
    "refundable" => "Refundable",
    "yes" => "yes",
    "no" => "no",
    "default" => "default",
    "commentType" => "Comment type",
    "ctype0" => "Comment",
    "ctype1" => "Notice",
    "ctype2" => "Caution!",
    "hint" => "Hint:",
    "rename_caution_before_username" => "If you change the username of",
    "rename_caution_after_username" => "you have to re-login under your new username immediately!",
    "timediff_warn" => "You must enter different times into the time in-/out fields!",
    "visibility" => "Visibility",
    "showitem" => "make visible",
    "hideitem" => "make invisible",
    "checkUsername" => "You must enter a username in the field left from the add-button!",
    "checkGroupname" => "You must enter a group name in the field left from the add-button!",
    "checkStatusname" => "You must enter a status name in the field left from the add-button!",
    "checkGlobalRoleName" => "You must enter a role name in the field left from the add-button!",
    "checkMembershipRoleName" => "You must enter a role name in the field left from the add-button!",
    "clickToReload" => "Click here to reload the GUI",
    "sure" => "Sure?",
    "clock" => "Clock",
    "currSum" => "Current Timeframe Summary",
    "admWarn" => "You are Admin. Status can only be set lower by another admin.",
    "flip_project_display" => "Order project table by customers",
    "project_comment_flag" => "Always show comments beside projects",
    "showIDs" => "Show IDs",
    "error" => "An error occured!",
    "checkupdate" => "Look for update",
    "selectedForRecording" => "Selected for recording:",
    "selectedCustomerLabel" => "C:",
    "selectedProjectLabel" => "P:",
    "selectedActivityLabel" => "T:",
    "testCustomer" => "Test-Customer",
    "testProject" => "Test-Project",
    "testActivity" => "testing",
    "time_billable" => "Billable Time",
    "billable" => "Billable",
    "budget" => "Budget",
    "effort" => "Effort",
    "rate" => "Rate (by hour)",
    "rate_short" => "Rate",
    "approved" => "Approved",
    "default_rate" => "Default rate",
    "my_rate" => "My rate",
    "fixedRate" => "Fixed rate",
    "used" => "Used",
    "budget_available" => "Budget available",
    "budget_activity" => "Budget of activity",
    "budget_activity_used" => "Budget used",
    "budget_activity_approved" => "Budget approved",
    "budget_minus" => "over budget",
    "wage" => "Amount",
    "roundTimesheetEntries" => "Round new timesheet entries to",
    "minutes" => "Minutes",
    "seconds" => "Seconds",
    "and" => "and",
    "customerlogin" => "customer login",
    "expense" => "Expense",
    "cleared" => "cleared",
    "atLeastOneGroup" => 'At least one group has to be selected.',
    "noFading" => "no fading effect",
    "user_list_hidden" => "hide user list by default",
    'show_update_warn' => 'Turn off warning before an update.',
    'check_at_startup' => 'Show a message on the login page if a newer version is available.',
    'show_daySeperatorLines' => 'Draw a line between entries of different days.',
    'show_gabBreaks' => 'Draw a line between two records that are not perfectly continuous.',
    'show_RecordAgain' => 'Show the &quot;Record Again&quot; button in front of every entry.',
    'show_TrackingNr' => 'Tracking Number is editable',
    'currency_name' => 'Currency Name',
    'currency_sign' => 'Currency Symbol',
    'currency_first' => 'Show currency name in front of value (e.g. &euro; 100,00)',
    'display_date_format' => 'Date format of the timespan (<a href="http://php.net/manual/en/function.strftime.php" target="_blank">notation for strftime()</a>)',
    'date_format_0' => 'Date format for the datepicker (<a href="http://api.jqueryui.com/datepicker/#utility-formatDate" target="_blank">notation for dateFormat</a>)',
    'date_format_3' => 'Date format of datepicker in PHP (must match the datepicker format above - <a href="http://php.net/manual/en/function.date.php" target="_blank">notation for date</a>)',
    'table_date_format' => 'Date format for tables (<a href="http://php.net/manual/en/function.strftime.php" target="_blank">notation for strftime()</a>)',
    'table_time_format' => 'Time format for tables (<a href="http://php.net/manual/en/function.strftime.php" target="_blank">notation for strftime()</a>)',
    'round_time' => 'Round time to ',
    'round_time_minute' => ' minute(s).',
    'allowRoundDown' => 'Allow rounding entries down.',
    'logged_in_as' => 'logged in as:',
    'decimal_separator' => 'Decimal separator',
    'view_filter' => 'view filter',
    'unassigned' => 'unassigned',
    'all_activities' => '&lt;&lt;all&gt;&gt;',
    'all' => 'all',
    'durationWithSeconds' => 'Show duration exact to the second.',
    'multiplier' => 'Multiplier',
    'timezone' => 'Time Zone',
    'dateAndTimeHelp' => '<strong>Times and dates have to be entered in the following form:</strong><br />Dates: DD.MM.YYYY<br />Times: HH:MM:SS or HH:MM or just HH. Ommitted parts will be set to 0.',
    'editNoteHelp' => '<strong>Comments can be entered in the order you wish<br />and can be changed later if necessary, without limit.</strong>',
    'defaultTimezone' => 'time zone for new users and customers',
    'editLimitPart1' => 'No entries can be added or edited which end more than',
    'editLimitPart2' => 'day(s) and',
    'editLimitPart3' => 'hour(s) in the past.',
    'editLimitError' => 'The end date is further in the past than it was allowed to be.',
    'hideClearedEntries' => 'hide cleared entries',
    'showCommentsByDefault' => 'show comments by default',
    'showTrackingNumber' => 'show tracking number in timesheet',
    'showBillability' => 'show billability in timesheet',
    'hideOverlapLines' => 'Don\'t indicate time overlap of entries',
    'defaultLocation' => 'Default location',
    'showQuickNote'	=> 'show quick note button',
    'inlineEditingOfDescriptions'	=> 'inline editing of descriptions',
    'general' => 'General',
    'address' => 'Address',
    'contact' => 'Contact',
    'list' => 'List',
    'sublists' => 'Lower Lists',
    'timesheet' => 'Timesheet',
    "filter" => "Filter",
    'internalProject' => 'internal project',
    'exactSums' => 'Use exact sums instead of adding the displayed rounded values.',
    'securityWarning' => 'security warning',
    'installerWarningHeadline' => 'installer folder still present!',
    'installerWarningText' => 'You should delete the installer folder so nobody else can reinstall Kimai.',
    'change' => 'change',
    'sublistAnnotations' => 'sublist annotations',
    'TimeDateInputError' => 'The time or date you entered is not valid.',
    'StartTimeBeforeEndTime' => 'The start time must be before the end time.',

    'credits' => <<<'EOD'
        If you do any alternations we would appreciate a posting on the <a href="%1$s">forum</a>.
        The latest developer version can be downloaded for test purposes <a href="%2$s">here</a>.
        <br /><br />
        Please support further development of Kimai with a <a href="%3$s">donation</a> or by extending its <a href="%5$s">translations</a>.
        If you find bugs or have ideas for features, please create a <a href="%4$s">ticket</a>.
EOD
    ,
    'credits_license' => 'This program is free software and published \'AS IS\' without any kind of warranty under the terms of the %1$s.',
    'credits_thanks' => 'Further thanks for support to:',
    'credits_libs' => 'Our thanks also go to the projects:',

    'months' => ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"],
    'months_short' => ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"],
    'weekdays' => ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"],
    'weekdays_short' => ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
    'quicklink_today' => 'Today',
    'quicklink_yesterday' => 'Yesterday',
    'quicklink_lastWeek' => 'Last Week',
    'quicklink_lastMonth' => 'Last Month',
    'quicklink_thisWeek' => 'This Week',
    'quicklink_thisMonth' => 'This Month',

    'errorMessages' => [
        'permissionDenied' => 'Permission denied',
        'userWithSameName' => 'A customer name can not be the same as a user name.',
        'userExistsAlready' => 'User exists already.',
        'customerWithSameName' => 'A user name can not be the same as a customer name.',
        'sameGlobalRoleName' => 'A global role with this name already exists.',
        'sameMembershipRoleName' => 'A membership role with this name already exists.',
        'noActivitySelected' => 'No activity selected.',
        'noProjectSelected' => 'No project selected.',
        'multiplierNegative' => 'The multiplier must be larger than 0.',
        'emptyField' => 'Missing value for field: %s',
        'wrongData' => 'The given data is invalid',
    ],

    'confirmations' => [
        'ownGlobalRoleChange' => 'Are you sure you want to change your own global role from "%OLD%" to "%NEW%"?\nThis can lead to less permissions!'
    ],

    'errors' => [
        0 => [
            'hdl' => "Database could not be connected!",
            'txt' => "Please make sure your Database is running, has an active PDO connector and the entries in 'autoconf.php' in folder 'includes' are correct."
        ],
        1 => [
            'hdl' => "Error during installation!",
            'txt' => 'Kimai is unable to create necessary tables because tables with the name name already exist.<br/>
To update your existing installation please click <a href="../index.php">here</a>.<br/>
Choose another table prefix or delete existing tables with this prefix in order to allow Kimai to perform a clean installation.'
        ]
    ],

    'updater' => [
        0 => "Yes, I have a backup of my Kimai database! Proceed updating!",
        10 => "Legend:",
        20 => "Query was executed successfully.",
        30 => "Query caused error - most likely irrelevant.",
        40 => "Query caused fatal error.",
        50 => "Backup Log:",
        60 => "Backup failed - Update aborded!",
        70 => "Update Log:",
        80 => "The database was updated successfully and a backup was created.",
        90 => "Queries processed.",
        100 => "The database-update failed due to fatal error(s). A backup was made which can be used to recreate the database in case Kimai does not work properly.",
        110 => "New Passwords",
        120 => "See below for new passwords for every user.",
        130 => "Could not write to autoconf.php.",
        140 => "update file autoconf.php",
        'timezone' => 'Kimai now supports timezones. Please select your default time zone. It will be used for all users and customers. Users can change their time zone.',
    ],

    'backup' => [
        0 => "This backup restore utility is not yet tested! Use at your own risk!",
        1 => "Available backups:",
        2 => "recover",
        3 => "delete",
        4 => "OK",
        5 => "You can only recover *one* backup at a time!",
        6 => "Backup from",
        7 => "was recovered.",
        8 => "create backup",
        9 => "These backups are actually snapshots! Meaning they still live within the very same database as your actual Kimai work data. Backups via this utility are NO substitution for real backups on a physically different data medium. There are plenty of tools for database backups available on the web ;)",
        10 => "Authentication required",
        11 => "To prevent unauthorized persons from creating, deleting or restoring backups, you need to give the password salt stored in include/autoconf.php. It only consists of letters and numbers."
    ],

    'export_extension' => [
        "print_hint" => "Click OK to open a printable table.",
        "dl_hint" => "Click OK to download export-file.",
        "tab_filter" => "Filter",
        "tab_location" => "Location",
        "tab_timeformat" => "Time Format",
        "cleared_all" => "all",
        "cleared_cleared" => "only cleared",
        "cleared_open" => "only open",
        "stdrd_location" => "Standard-Location",
        "timeformat" => "Time Format",
        "dateformat" => "Date Format",
        "refundable_all" => "all",
        "refundable_refundable" => "only refundable",
        "refundable_not_refundable" => "only non refundable",
        "print_comment" => "print comments",
        "print_summary" => "print summary",
        "create_bookmarks" => "create bookmarks",
        "download_pdf" => "download as PDF",
        "pdf_format" => "format",
        "export_pdf" => "table",
        "export_pdf2" => "list",
        "column_delimiter" => "delimiter for columns",
        "quote_char" => "boundary character for fields",
        "exportCSV" => "CSV Export",
        "exportPDF" => "PDF Export",
        "exportXLS" => "Excel Export",
        "print" => "Print",
        "export_timeformat_help" => "Time Format Help",
        'subtotal' => 'Sub Total',
        'finalamount' => 'Total',
        'pdf_headline' => 'List of working time and expenses',
        'pdf_headline_only_times' => 'List of working time',
        'pdf_headline_only_expenses' => 'List of expenses',
        'costs' => 'Costs',
        'expense' => 'Expense',
        'summary' => 'Summary',
        'full_list' => 'Full List',
        'page' => 'Page',
        'by' => 'by',
        'done_by' => 'done by',
        'duration' => 'Duration',
        'customer_new_page' => 'new page for each customer',
        'times_and_expenses' => 'times and expenses',
        'times' => 'times',
        'expenses' => 'expenses',
        'reverse_order' => 'older entries first',
        'time_period' => 'Time period',
        'duration_unit' => 'h',
        'time_type' => 'Time format',
        'dec_time' => 'Decimal time',
        'time' => 'Standard time',
        'cleared' => 'Cleared',
    ],

    'ext_invoice' => [
        'invoiceTitle' => 'Create invoice',
        'invoiceCustomer' => 'Customer',
        'invoiceProject' => 'Projects',
        'invoiceTimePeriod' => 'Time Period',
        'invoiceTemplate' => 'Invoice template',
        'defaultVat' => 'VAT rate',
        'invoiceOptionShort' => 'Short Invoice',
        'invoiceOptionRound' => 'Round time',
        'markEntriesAsCleared' => 'Mark entries as cleared',
        'invoiceButton' => 'Create',
        'noData' => 'There are no entries for the selected project & time period',
        'noProject' => 'No project was selected.',
        'includedEntries' => 'Include entries',
        'failure' => 'Failed rendering invoice: %s',
        'sortOrder' => 'Order',
        'orderDateAsc' => 'Date - oldest first',
        'orderDateDesc' => 'Date - newest first',
        'noDateSelected' => 'Missing time period',
    ],

    'ext_budget' => [
        'unusedBudget' => 'unused'
    ],

    'extensionsTitle' => 'Extensions',

    'permissions' => [
        'view' => 'View',
        'edit' => 'edit',
        'delete' => 'delete',
        'assign' => 'assign',
        'unassign' => 'unassign',
        'ownEntry' => 'own entry',
        'otherEntry' => 'entry of other user',
        'ownGroup' => 'same group',
        'otherGroup' => 'different group',
        'showRates' => 'show rates',
        'editRates' => 'edit rates',
        'editAdvanced' => 'edit advanced settings'
    ],

    'extensions' => [
        'adminPanel_extension' => 'Admin Panel',
        'ki_timesheet' => 'Timesheet',
        'ki_timesheets' => 'Timesheet',
        'ki_expenses' => 'Expenses',
        'ki_invoice' => 'Invoice',
        'deb_ext' => 'Debug',
        'ap_ext' => 'Preference',
        'ki_budget' => 'Budget',
        'ki_export' => 'Export',
        'core' => 'Permissions',
        'demo_ext' => 'Demo'
    ],

    'updatecheck' => [
        'release' => "<b>An official update is available, with new features and bugfixes. We strongly suggest that you update.</b>",
        'beta' => "<i>New beta version available. You can fetch it from the download page for testing, but don't use it for production environments.</i>",
        'current' => "You are running the latest version :)"
    ],

    'debug' => [
        'lines' => '(limited to %s lines)',
        'logfile' => 'LOGFILE',
        'clear' => 'Clear logfile',
        'log_delete' => 'log cleared',
    ],

];
