<?php
/**
 * This file is part of
 * Kimai - Open Source Time Tracking // https://www.kimai.org
 * (c) Kimai-Development-Team since 2006
 *
 * Kimai is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; Version 3, 29 June 2007
 *
 * Kimai is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Kimai; If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Truncates a given message
 */
class Zend_View_Helper_Ellipsis extends Zend_View_Helper_Abstract
{
    /**
     * Truncates a given message
     * 
     * @param string $text
     * @param int $maxLength
     * @return string
     */
    public function ellipsis($text, $maxLength = 5)
    {
        if (strlen($text) > $maxLength) {
            return substr($text, 0, $maxLength) . '…';
        }

        return $text;
    }
} 
