# Arduino Libray utility

[toc]

## History
Array Library for Arduino
Author:  Alexander Brevig
Contact: alexanderbrevig@gmail.com

1.0 2009-06-17 - Alexander Brevig : Initial Release
1.0 2009-06-17 - Alexander Brevig : foreach
1.1 2009-06-17 - Alexander Brevig : sign
1.2 2009-06-17 - Alexander Brevig : extended templating
2.0 2019-11-20 - Marcel Jordaan   : Corrected version arduino version >= 100

## Description
Array is a library for the Arduino.
It is created to help simplify the handling of raw c++ arrays. 

## Download, install and import
Library ZIP file: utility.zip

Add the utility library, in the Arduino IDE select from the menubar "Sketch->Include Library->Add .ZIP Library". Select the library file 'utility.zip' and confirm the choice, library will now be added.

In the Arduino IDE, create a new sketch (or open one) and select from the menubar "Sketch->Import Library->utility".

Once the library is imported, an '#include <utility.h>' line will appear at the top of your Sketch.

## Creation
    Array<datatype> variableName = Array<datatype>( array , size ); 

## Functions
### foreach
This function takes an array of pins, the length of the array, target function and the modifier for the function as parameters.
``` c
foreach( array, length, function, modifier);
foreach( ledPins, 10, digitalWrite, HIGH );
```
### sign
Determines if a value is equal,belov or above 0
``` c
int x = 2;

int signum = sign(x); //1
```
## Example
``` c
#include <Utility.h>
     
const byte NUMBER_OF_PINS = 4;
byte ledPin[NUMBER_OF_PINS] = {10,11,12,13};
     
void setup() {
  foreach(ledPin, NUMBER_OF_PINS, pinMode, OUTPUT); //set all pins as OUTPUT
}
     
void loop() {
  foreach(ledPin, NUMBER_OF_PINS, digitalWrite, HIGH); //set all pins HIGH
  delay(1000);
     
  foreach(ledPin, NUMBER_OF_PINS, digitalWrite, LOW); //set all pins LOW
  delay(1000);
     
  //manipulate pins from index 1 to index 3, inclusive
  foreach(ledPin, 1, 3, digitalWrite, HIGH);//set pin 11,12 and 13 HIGH
  delay(500);
     
  //manipulate pins from index 1 to index 2, inclusive
  foreach(ledPin, 1, 2, digitalWrite, LOW);//set pin 11 and 12 LOW
  delay(500);
}
```
