import React, { ReactElement, ReactNode, CSSProperties } from 'react';

interface Props {
  children: ReactNode;
  className?: string;
  style?: CSSProperties;
}

export default function Container({
  children,
  className,
  style,
}: Props): ReactElement {
  return (
    <div
      className={`w-full flex flex-column align-items-center px-2 py-8 ${
        className ?? ''
      }`}
      style={style}
    >
      {children}
    </div>
  );
}
