import { Company, Slot } from '@jbd/end-user-business-logic';
import React, { ReactElement } from 'react';
import styled from 'styled-components';
import format from 'date-fns/format';
import parseISO from 'date-fns/parseISO';
import { Button } from 'primereact/button';

interface Props {
  slot: Slot;
  onSelectCompany(company: Company): void;
}

const SlotCardLogo = styled.img`
  max-height: 80px;
  max-width: 300px;
`;

export default function RouteSlotCard({
  slot,
  onSelectCompany,
}: Props): ReactElement {
  const isCompany = slot.company !== undefined;
  if (isCompany) {
    const company = slot.company;
    return (
      <div>
        {company.logo && <SlotCardLogo alt={company.name} src={company.logo} />}
        <h3 className="my-1">{company.name}</h3>
        <span>{slot.name}</span>
        <div>
          {format(parseISO(slot.start), 'HH:mm')} &ndash;
          {format(parseISO(slot.end), 'HH:mm')}
        </div>
        <div className="p-2">
          <Button
            className="p-button-sm"
            onClick={() => onSelectCompany(company)}
            label="Bekijk"
          />
        </div>
      </div>
    );
  }
  return (
    <div>
      <span>{slot.name}</span>
      <div>
        {format(parseISO(slot.start), 'HH:mm')} &ndash;
        {format(parseISO(slot.end), 'HH:mm')}
      </div>
    </div>
  );
}
