import { PollQuestion } from '@jbd/end-user-business-logic';
import { Field, useFormikContext } from 'formik';
import { InputText } from 'primereact/inputtext';
import { SelectButton } from 'primereact/selectbutton';
import React, { ReactElement } from 'react';

interface Props {
  question: PollQuestion;
  name: string;
}

export default function FeedbackPollQuestion({
  question,
  name,
}: Props): ReactElement {
  const { values, errors, setFieldValue } = useFormikContext();

  const minMaxRules = question.rules as { min: number; max: number };
  return (
    <div key={question.id} className="pt-2 pb-2">
      <strong className="block">{question.title}</strong>
      <small className="block mb-1">{question.description}</small>
      {question.type === 'open' && (
        <InputText
          className="p-inputtext-sm w-full"
          placeholder="Vul hier je antwoord in."
          value={values[name]}
          onChange={(evt) => setFieldValue(name, evt.target.value)}
        />
      )}
      {question.type === 'range' && (
        <SelectButton
          className="w-full"
          options={Array.from({
            length: minMaxRules.max - minMaxRules.min + 1,
          }).map((_, index) => ({
            label: minMaxRules.min + index,
            value: minMaxRules.min + index,
          }))}
          onChange={(evt) => setFieldValue(name, evt.value)}
          value={values[name]}
        />
      )}
      {question.type === 'selectOne' && (
        <SelectButton
          className="w-full p-selectbutton-sm"
          options={question.options.map((o, i) => ({
            label: o.title,
            value: i,
          }))}
          onChange={(evt) => setFieldValue(name, evt.value)}
          value={values[name]}
        />
      )}
      <p className="text-pink-800 text-sm m-0">
        {errors[name] && errors[name]}
      </p>
    </div>
  );
}
