import { Message } from '@jbd/end-user-business-logic';
import React, { ReactElement } from 'react';
import { useQuery } from 'react-query';
import format from 'date-fns/format';
import nl from 'date-fns/locale/nl';
import { useAuthentication, useServices } from '@jbd/end-user-utils';

interface Props {
  message: Message;
}

export default function FullMessage({ message }: Props): ReactElement {
  const { user } = useAuthentication();
  const { messageService } = useServices();

  const { data } = useQuery(['user', user.id, 'messages', message.id], () =>
    messageService.getMessageById(user.id, message.id)
  );

  return (
    <div>
      <h2 className="my-0">{message.subject}</h2>
      <span className="text-xs text-bluegray-500">
        {format(new Date(message.receivedAt), 'PPPpp', { locale: nl })}
      </span>
      <div
        className="pt-3 mt-3"
        style={{ whiteSpace: 'pre-wrap', borderTop: '1px solid #ccc' }}
      >
        {data?.body ?? message.body}
      </div>
      <p>&mdash; {message.sender.name}</p>
    </div>
  );
}
