import { PollMetadata } from '@jbd/end-user-business-logic';
import React, { ReactElement } from 'react';
import { ListBox } from 'primereact/listbox';
import { ScrollPanel } from 'primereact/scrollpanel';
import styled from 'styled-components';

interface Props {
  polls: PollMetadata[];
  onSelectPoll(pollId: string | null): void;
  selectedPollId: string | null;
}

const StyledScrollPanel = styled(ScrollPanel)`
  width: 100%;
  height: 100%;
  background-color: white;
  border-radius: 2px;

  &.custom .p-scrollpanel-wrapper {
    border-right: 9px solid #f4f4f4;
  }

  &.custom .p-scrollpanel-bar {
    background-color: rgb(0, 140, 214);
    opacity: 1;
    transition: background-color 0.3s;
    border-radius: 0;
  }

  &.custom .p-scrollpanel-bar:hover {
    background-color: #135ba1;
  }

  &.custom .p-listbox .p-listbox-list {
    padding: 0;
  }

  .p-scrollpanel-content {
    height: 100%;
    overflow-y: auto;
    overflow-x: hidden;
    padding-bottom: 0;
  }
`;

function PollsListItem({ poll }: { poll: PollMetadata }): ReactElement {
  return (
    <div>
      <h4 className="mt-1 mb-0">{poll.poll.title}</h4>
    </div>
  );
}

export default function PollsList({
  polls,
  onSelectPoll,
  selectedPollId,
}: Props): ReactElement {
  return (
    <StyledScrollPanel className="custom">
      <ListBox
        value={polls.find((m) => m.id === selectedPollId)}
        options={polls}
        onChange={(e) => onSelectPoll(e.value?.id ?? null)}
        itemTemplate={(option) => <PollsListItem poll={option} />}
      />
    </StyledScrollPanel>
  );
}
