import { Company, Slot } from '@jbd/end-user-business-logic';
import { InfoWindow, Marker } from '@react-google-maps/api';
import React, { ReactElement, useState } from 'react';
import RouteSlotCard from '../atoms/RouteSlotCard';

interface Props {
  slot: Slot;
  onSelectCompany(company: Company): void;
}

export default function RouteSlotMarker({
  slot,
  onSelectCompany,
}: Props): ReactElement {
  const [isOpen, setIsOpen] = useState<boolean>(false);
  const destination = slot.company ?? slot.school ?? slot.location;

  const coords = destination.address?.position.coordinates ?? [0, 0];
  const position = { lat: coords[1], lng: coords[0] };

  return (
    <Marker position={position} onClick={() => setIsOpen(true)}>
      {isOpen && (
        <InfoWindow onCloseClick={() => setIsOpen(false)}>
          <RouteSlotCard slot={slot} onSelectCompany={onSelectCompany} />
        </InfoWindow>
      )}
    </Marker>
  );
}
