import { GroupMember } from '@jbd/end-user-business-logic';
import React, { ReactElement } from 'react';
import { useQuery } from 'react-query';
import { DataTable } from 'primereact/datatable';
import { Column } from 'primereact/column';
import Container from '../atoms/Container';
import { useAuthentication, useServices } from '@jbd/end-user-utils';

export default function GroupSection(): ReactElement {
  const { groupService } = useServices();

  const { permissions } = useAuthentication();
  const group = permissions.groups[0];
  const school = group.school;
  const organisation = school.organisation;

  const { data } = useQuery(['group', group.id, 'members'], () =>
    groupService.getMembers(organisation.id, school.id, group.id)
  );

  const members = data ?? [];

  return (
    <Container className="bg-bluegray-100">
      <h1 className="mt-0">Jouw groep</h1>
      <p>
        Je bent lid van groep {group.name} en hebt daarin de rol{' '}
        {group.accessLevelPretty}. Er zitten nog {members.length - 1} anderen in
        deze groep.
      </p>
      <div style={{ maxWidth: 800 }}>
        <DataTable value={members ?? []}>
          <Column
            field="username"
            body={(row: GroupMember) => {
              if (!(row.person?.firstName || row.person?.lastName)) {
                return <span>{row.username}</span>;
              }
              return (
                <span>
                  {row.person.firstName} {row.person.insertion}{' '}
                  {row.person.lastName}
                </span>
              );
            }}
            header={group.name}
          ></Column>
          <Column field="person.phoneNumber" header=""></Column>
          <Column field="accessLevelPretty" header=""></Column>
        </DataTable>
      </div>
    </Container>
  );
}
