import { Message } from '@jbd/end-user-business-logic';
import React, { ReactElement, useState, useEffect, useRef } from 'react';
import { Card } from 'primereact/card';
import { Toast } from 'primereact/toast';
import MessagesList from '../molecules/MessagesList';
import FullMessage from '../molecules/FullMessage';
import MessageForm from '../molecules/MessageForm';

interface Props {
  messages: Message[];
}

export default function MessagesContainer({ messages }: Props): ReactElement {
  const [isComposingMessage, setIsComposingMessage] = useState<boolean>(false);
  const [selectedMessageId, setSelectedMessageId] = useState<string | null>(
    null
  );
  const selectedMessage = messages.find((m) => m.id === selectedMessageId);

  const toast = useRef<Toast>(null);

  return (
    <div className="w-full flex flex-column-reverse md:flex-row lg:flex-row xl:flex-row justify-content-stretch align-items-stretch">
      <div className="flex-shrink-0">
        <MessagesList
          messages={messages}
          onSelectMessage={(messageId) => {
            setSelectedMessageId(messageId);
            setIsComposingMessage(false);
          }}
          onClickCompose={() => {
            setIsComposingMessage(true);
            setSelectedMessageId(null);
          }}
          selectedMessageId={selectedMessageId}
        />
      </div>
      <Card className="w-full shadow-none">
        {isComposingMessage && (
          <MessageForm
            toast={toast.current}
            onComplete={() => setIsComposingMessage(false)}
          />
        )}
        {!isComposingMessage && selectedMessage && (
          <FullMessage message={selectedMessage} />
        )}
        {!isComposingMessage && !selectedMessage && (
          <p className="text-center text-bluegray-500">
            Selecteer een bericht uit de lijst of stel een nieuw bericht op.
          </p>
        )}
      </Card>
      <Toast ref={toast} />
    </div>
  );
}
