import { useAuthentication, useServices } from '@jbd/end-user-utils';
import React, { ReactElement } from 'react';
import { useQuery } from 'react-query';
import Container from '../../atoms/Container';
import Loading from '../../Loading';
import FeedbackPollsContainer from '../FeedbackPollsContainer';

export default function FeedbackSection(): ReactElement {
  const { user } = useAuthentication();
  const { eventService } = useServices();

  const { data } = useQuery(['user', user.id, 'polls'], () =>
    eventService.getFeedbackPolls(user.id)
  );

  return (
    <Container
      className="text-white"
      style={{ backgroundColor: 'rgb(0, 140, 214)' }}
    >
      <h1 className="my-0">Jouw feedback</h1>
      {data ? (
        <div style={{ maxWidth: 800, width: '100%' }}>
          {data.length > 0 ? (
            <>
              <p className="text-center">
                We horen graag wat jij van de Jongeren Bedrijvendag vond!
              </p>
              <FeedbackPollsContainer polls={data} />
            </>
          ) : (
            <p className="text-center">
              Je hebt momenteel geen feedbackverzoeken openstaan.
            </p>
          )}
        </div>
      ) : (
        <Loading />
      )}
    </Container>
  );
}
