import React, { ReactElement } from 'react';
import { useQuery } from 'react-query';
import Loading from '../../Loading';
import 'react-vertical-timeline-component/style.min.css';
import Container from '../../atoms/Container';
import MessagesContainer from '../MessagesContainer';
import { useAuthentication, useServices } from '@jbd/end-user-utils';

export default function MessagesSection(): ReactElement {
  const { user } = useAuthentication();
  const { messageService } = useServices();

  const { data } = useQuery(['user', user.id, 'messages'], () =>
    messageService.getMessages(user.id)
  );

  return (
    <Container className="bg-bluegray-100">
      <h1 className="my-0">Jouw berichten</h1>
      {data ? (
        <div style={{ maxWidth: 800, width: '100%' }}>
          {data.length > 0 ? (
            <>
              <p className="text-center">
                Hieronder vind je jouw ontvangen berichten.
              </p>
              <MessagesContainer messages={data} />
            </>
          ) : (
            <p className="text-center">Je hebt nog geen berichten ontvangen.</p>
          )}
        </div>
      ) : (
        <Loading />
      )}
    </Container>
  );
}
