import React, { ReactElement } from 'react';
import { Company } from '@jbd/end-user-business-logic';
import RouteMap from '../RouteMap';
import { useQuery } from 'react-query';
import { useEventContext, useServices } from '@jbd/end-user-utils';

interface Props {
  onSelectCompany(company: Company): void;
}

export default function RouteMapSection({
  onSelectCompany,
}: Props): ReactElement {
  const { group, organisation, event } = useEventContext();
  const { eventService } = useServices();

  const { data } = useQuery(['group', group.id, 'route'], () =>
    eventService.getRoute(organisation.id, event.id, group.id)
  );

  const slots = data?.slots;

  return slots ? (
    <RouteMap onSelectCompany={onSelectCompany} slots={slots} />
  ) : null;
}
