import React, { ReactElement } from 'react';
import styled from 'styled-components';
import Container from '../../atoms/Container';

const LogoRabobank = 'RABOBANK_LOGO.png';
const LogoGemeenteOss = 'GEMEENTE_OSS.png';
const LogoGemeenteBernheze = 'BERNHEZE_LOGO.png';
const LogoTalentenCampus = 'TALENTENCAMPUSOSS.png';
const LogoJongerenOpWeg = 'JOWNB_LOGO_FC.png';
const LogoHooghuis = 'HHL_LOGO.png';
const LogoMaasland = 'MAASLANDCOLLEGE_LOGO.png';
const LogoLions = 'LIONS_LOGO.png';
const LogoInfraMensen = 'Logo_Inframensen_Zuid_CMYK.png';
const LogoBouwMensen = 'BOUWMENSEN_OSS_CMYK.png';
const LogoBouwkring = 'Logo_Bouwkring_BrabantNoordOost.png';
const LogoSchildersVakopleiding = 'SchildersVakopleiding.png';
const LogoOIK = 'OIK_CMYK.png';
const LogoIw = 'IW_Pay_off_CMYK.png';
const LogoNoa = 'NOA__contouren.png';
const LogoTibo = 'tibo.png';

const sponsors = [
  LogoRabobank,
  LogoGemeenteOss,
  LogoGemeenteBernheze,
  LogoTalentenCampus,
  LogoJongerenOpWeg,
  LogoHooghuis,
  LogoMaasland,
  LogoLions,
  LogoInfraMensen,
  LogoBouwMensen,
  LogoBouwkring,
  LogoSchildersVakopleiding,
  LogoOIK,
  LogoIw,
  LogoNoa,
  LogoTibo,
];

const BigSponsorImage = styled.img`
  max-width: 80%;
  max-height: 200px;
  margin: 20px;
  vertical-align: center;
`;

const SponsorImage = styled.img`
  max-width: 90%;
  max-height: 200px;
  margin: 20px;
  vertical-align: center;
`;

const bigSponsorClasses = 'sm:col-12 md:col-6 lg:col-6 xl:col-6';
const normalSponsorClasses = 'sm:col-6 md:col-3 lg:col-3 xl:col-3';
const smallSponsorClasses = 'sm:col-4 md:col-2 lg:col-2 xl:col-2';

export default function SponsorsSection(): ReactElement {
  return (
    <Container>
      <h1 className="my-0">Onze sponsoren</h1>
      <div style={{ maxWidth: 800 }}>
        <div className="grid text-center align-items-center justify-content-center">
          <div className={bigSponsorClasses}>
            <BigSponsorImage alt={sponsors[0]} src={'/assets/' + sponsors[0]} />
          </div>
          <div className={bigSponsorClasses}>
            <BigSponsorImage alt={sponsors[1]} src={'/assets/' + sponsors[1]} />
          </div>
          <div className={normalSponsorClasses}>
            <SponsorImage alt={sponsors[2]} src={'/assets/' + sponsors[2]} />
          </div>
          <div className={normalSponsorClasses}>
            <SponsorImage alt={sponsors[3]} src={'/assets/' + sponsors[3]} />
          </div>
          <div className={normalSponsorClasses}>
            <SponsorImage alt={sponsors[4]} src={'/assets/' + sponsors[4]} />
          </div>
          <div className={normalSponsorClasses}>
            <SponsorImage alt={sponsors[5]} src={'/assets/' + sponsors[5]} />
            <SponsorImage alt={sponsors[6]} src={'/assets/' + sponsors[6]} />
          </div>
          <div className={smallSponsorClasses}>
            <SponsorImage alt={sponsors[15]} src={'/assets/' + sponsors[15]} />
          </div>
          <div className={smallSponsorClasses}>
            <SponsorImage alt={sponsors[7]} src={'/assets/' + sponsors[7]} />
          </div>
          <div className={smallSponsorClasses}>
            <SponsorImage alt={sponsors[13]} src={'/assets/' + sponsors[13]} />
          </div>
          <div className={smallSponsorClasses}>
            <SponsorImage alt={sponsors[12]} src={'/assets/' + sponsors[12]} />
          </div>
          <div className={smallSponsorClasses}>
            <SponsorImage alt={sponsors[8]} src={'/assets/' + sponsors[8]} />
            <SponsorImage alt={sponsors[9]} src={'/assets/' + sponsors[9]} />
          </div>
          <div className={smallSponsorClasses}>
            <SponsorImage alt={sponsors[14]} src={'/assets/' + sponsors[14]} />
            <SponsorImage alt={sponsors[11]} src={'/assets/' + sponsors[11]} />
            <SponsorImage alt={sponsors[10]} src={'/assets/' + sponsors[10]} />
          </div>
        </div>
      </div>
    </Container>
  );
}
