import React, { ReactElement, useEffect } from 'react';
import { useQuery } from 'react-query';
import Link from 'next/link';
import { useRouter } from 'next/router';
import Loading from '../../components/Loading';
import { Card } from 'primereact/card';
import Container from '../atoms/Container';
import styled from 'styled-components';
import { useServices } from '@jbd/end-user-utils';

const StyledA = styled.a`
  text-decoration: none;
`;

export default function PublicPage(): ReactElement {
  const router = useRouter();
  const { publicService } = useServices();

  const { isFetched, isLoading, data } = useQuery(
    ['public', 'organisations'],
    () => publicService.getOrganisations()
  );

  const organisations = data;

  useEffect(() => {
    if (isFetched && organisations?.length === 1) {
      // Only one organisation, so forward to that page.
      router.push(`/publiek/${organisations[0].slug}/bedrijven`);
    }
  }, [isFetched, organisations, router]);

  if (isLoading || !isFetched || !organisations || organisations.length === 1) {
    return <Loading />;
  }

  return (
    <Container
      className="text-white"
      style={{
        backgroundColor: 'rgb(0, 140, 214)',
        minHeight: 'calc(100% - 65px)',
      }}
    >
      <div className="text-center" style={{ maxWidth: 800 }}>
        <h1 className="my-0">
          Van welke gemeente wil je de bedrijvencatalogus bekijken?
        </h1>
        <p className="mb-4">
          Er doen dit jaar meerdere gemeentes mee aan de Jongeren Bedrijvendag!
          Kies hieronder de gemeente waar je de deelnemende bedrijven van wilt
          zien.
        </p>
        {isFetched ? (
          <div className="flex flex-row cursor-pointer align-self-center">
            {organisations.map((org) => (
              <div key={org.id} className="p-3">
                <Link passHref href={`/publiek/${org.slug}/bedrijven`}>
                  <StyledA>
                    <Card>{org.name}</Card>
                  </StyledA>
                </Link>
              </div>
            ))}
          </div>
        ) : (
          <Loading />
        )}
      </div>
    </Container>
  );
}
