// eslint-disable-next-line @typescript-eslint/no-var-requires
const withNx = require('@nrwl/next/plugins/with-nx');
const withPWA = require('next-pwa')
const runtimeCaching = require('next-pwa/cache')

const isDev = process.env.NODE_ENV === "development";

/**
 * @type {import('@nrwl/next/plugins/with-nx').WithNxOptions}
 **/
const nextConfig = {
  async rewrites() {
    return [
      {
        source: '/api/:path*',
        destination: process.env.NEXT_PUBLIC_JBD_API_URL + '/:path*' // Proxy to Backend
        // destination: 'http://localhost:3030/:path*' // Proxy to Backend
      }
    ]
  },
  pwa: !isDev ? {
    dest: 'public',
    runtimeCaching,
    register: true,
    skipWaiting: true,
  } : undefined,
  nx: {
    // Set this to true if you would like to to use SVGR
    // See: https://github.com/gregberge/svgr
    svgr: false,
  },
};

module.exports = isDev ? withNx(nextConfig) : withNx(withPWA(nextConfig));
