import { useAuthentication } from '@jbd/end-user-utils';
import { useRouter } from 'next/router';
import React, { ReactElement, useEffect } from 'react';
import Loading from '../../components/Loading';
import PrivatePage from '../../components/pages/PrivatePage';

export default function AppIndex(): ReactElement {
  const router = useRouter();
  const { user, permissions, isAuthenticated } = useAuthentication();

  useEffect(() => {
    if (isAuthenticated === false) {
      router.push('/login');
    }
  }, [isAuthenticated, router]);

  if (!user || !permissions) {
    return <Loading />;
  }

  return <PrivatePage />;
}
