import Link from 'next/link';
import React, { ReactElement } from 'react';
import styled from 'styled-components';

const Navbar = styled.nav`
  background-color: rgb(0, 140, 214);
  display: flex;
  justify-content: space-between;
  border-bottom: 4px solid rgb(0, 112, 171);
  padding: 0.5rem 1rem;
`;

const Logo = styled.img`
  margin-top: 5px;
  max-height: 40px;
  cursor: pointer;
`;

export default function Topbar(): ReactElement {
  return (
    <Navbar>
      <Link href="/" passHref>
        <Logo alt="JBD" src="/assets/jbd_logo.png" />
      </Link>
      <div className="flex flex-row justify-content-center align-items-center">
        <strong className="text-white">PREVIEW</strong>
      </div>
    </Navbar>
  );
}
