import { Company } from '@jbd/end-user-business-logic';
import { Card } from 'primereact/card';
import React, { ReactElement } from 'react';
import styled from 'styled-components';
import { Button } from 'primereact/button';
import { useRouter } from 'next/router';
interface Props {
  company: Company;
}

const Logo = styled.img`
  max-width: 80%;
  max-height: 150px;
  margin-bottom: 3px;
  margin: 10px;
`;

function stripHtml(html: string) {
  // Create a new div element
  const tempDivElement = document.createElement('div');
  // Set the HTML content with the providen
  tempDivElement.innerHTML = html;
  // Retrieve the text property of the element (cross-browser support)
  return tempDivElement.textContent || tempDivElement.innerText || '';
}

export default function CompanyListItem({ company }: Props): ReactElement {
  const router = useRouter();
  const info = stripHtml(company.info).slice(0, 100);

  return (
    <Card className="flex flex-column flex-grow-1 shadow-2 h-full">
      <div
        className="w-full text-center flex flex-row align-items-center justify-content-center"
        style={{ height: 163 }}
      >
        <Logo src={company.logo} />
      </div>
      <div className="flex flex-row my-3">
        {company.categories?.map((c) => (
          <div
            key={c.id}
            style={{ flexGrow: 1, backgroundColor: c.color, height: 3 }}
            data-pr-tooltip={c.name}
          />
        ))}
      </div>
      <strong className="flex align-items-start justify-content-start">
        {company.name}
      </strong>
      <p>{info}...</p>
      <Button
        type="button"
        className="p-button-outlined p-button-block"
        onClick={() =>
          router.push(
            `/preview/?organisationId=${router.query.organisationId}&companyId=${company.id}`
          )
        }
      >
        Bekijken
      </Button>
    </Card>
  );
}
