import { useRouter } from 'next/router';
import React, { ReactElement } from 'react';
import { useQuery } from 'react-query';
import Loading from '../components/Loading';
import { PreviewService } from '@jbd/preview-business-logic';
import PreviewCompaniesPage from '../components/pages/PreviewCompaniesPage';
import axios from 'axios';

export default function Companies(): ReactElement {
  const router = useRouter();
  const { organisationId } = router.query;
  const previewService = new PreviewService(axios);

  const { data: organisation } = useQuery(
    ['preview', 'organisations', organisationId],
    () =>
      organisationId === undefined
        ? undefined
        : previewService.getOrganisation(organisationId as string)
  );

  return organisation ? (
    <PreviewCompaniesPage organisation={organisation} />
  ) : (
    <Loading />
  );
}
