/* eslint-disable @next/next/no-html-link-for-pages */
/* eslint-disable @next/next/no-img-element */
import { useState } from 'react';
import Gallery from 'react-grid-gallery';

const THUMBNAIL_WIDTH = 60;
const THUMBNAIL_HEIGHT = 30;
const IMAGES = [
  {
    src: '/assets/images/media/1.jpg',
    thumbnail: '/assets/images/media/1.jpg',
    thumbnailWidth: THUMBNAIL_WIDTH,
    thumbnailHeight: THUMBNAIL_HEIGHT,
  },
  {
    src: '/assets/images/media/2.jpg',
    thumbnail: '/assets/images/media/2.jpg',
    thumbnailWidth: THUMBNAIL_WIDTH,
    thumbnailHeight: THUMBNAIL_HEIGHT,
  },
  {
    src: '/assets/images/media/3.jpg',
    thumbnail: '/assets/images/media/3.jpg',
    thumbnailWidth: THUMBNAIL_WIDTH,
    thumbnailHeight: THUMBNAIL_HEIGHT,
  },
  {
    src: '/assets/images/media/4.jpg',
    thumbnail: '/assets/images/media/4.jpg',
    thumbnailWidth: THUMBNAIL_WIDTH,
    thumbnailHeight: THUMBNAIL_HEIGHT,
  },
  {
    src: '/assets/images/media/5.jpg',
    thumbnail: '/assets/images/media/5.jpg',
    thumbnailWidth: THUMBNAIL_WIDTH,
    thumbnailHeight: THUMBNAIL_HEIGHT,
  },
  {
    src: '/assets/images/media/6.jpg',
    thumbnail: '/assets/images/media/6.jpg',
    thumbnailWidth: THUMBNAIL_WIDTH,
    thumbnailHeight: THUMBNAIL_HEIGHT,
  },
  {
    src: '/assets/images/media/7.jpg',
    thumbnail: '/assets/images/media/7.jpg',
    thumbnailWidth: THUMBNAIL_WIDTH,
    thumbnailHeight: THUMBNAIL_HEIGHT,
  },
  {
    src: '/assets/images/media/8.jpg',
    thumbnail: '/assets/images/media/8.jpg',
    thumbnailWidth: THUMBNAIL_WIDTH,
    thumbnailHeight: THUMBNAIL_HEIGHT,
  },
  {
    src: '/assets/images/media/9.jpg',
    thumbnail: '/assets/images/media/9.jpg',
    thumbnailWidth: THUMBNAIL_WIDTH,
    thumbnailHeight: THUMBNAIL_HEIGHT,
  },
  {
    src: '/assets/images/media/10.jpg',
    thumbnail: '/assets/images/media/10.jpg',
    thumbnailWidth: THUMBNAIL_WIDTH,
    thumbnailHeight: THUMBNAIL_HEIGHT,
  },
  {
    src: '/assets/images/media/11.jpg',
    thumbnail: '/assets/images/media/11.jpg',
    thumbnailWidth: THUMBNAIL_WIDTH,
    thumbnailHeight: THUMBNAIL_HEIGHT,
  },
  {
    src: '/assets/images/media/12.jpg',
    thumbnail: '/assets/images/media/12.jpg',
    thumbnailWidth: THUMBNAIL_WIDTH,
    thumbnailHeight: THUMBNAIL_HEIGHT,
  },
  {
    src: '/assets/images/media/13.jpg',
    thumbnail: '/assets/images/media/13.jpg',
    thumbnailWidth: THUMBNAIL_WIDTH,
    thumbnailHeight: THUMBNAIL_HEIGHT,
  },
];

export function Index() {
  const [isFullMessageVisible, setIsFullMessageVisible] =
    useState<boolean>(false);

  return (
    <>
      <div id="page-wrapper">
        <header id="header" className={isFullMessageVisible ? 'expanded' : ''}>
          <div className="container">
            <div className="topbar">
              <img
                src="/assets/images/logo.png"
                width="200"
                height="60"
                alt="JBD"
              />
              <ul id="navigation">
                <li>
                  <a href="#doelstelling">Doelstelling</a>
                </li>
                <li>
                  <a href="#bedrijven">Bedrijven</a>
                </li>
                <li>
                  <a href="#programma">Programma</a>
                </li>
                <li>
                  <a href="#media">Media</a>
                </li>
              </ul>
            </div>
            <div id="welcome-message-wrapper">
              {!isFullMessageVisible && (
                <div id="welcome-message">
                  <h1>Welkom</h1>
                  <p>Beste deelnemers aan de Jongeren Bedrijven Dag,</p>
                  <p>
                    Op 5 maart 2024 vindt de 8e editie plaats van de
                    Jongerenbedrijvendag. De Lionsclub Oss heeft aan de basis
                    gestaan van deze dag waarbij scholieren die voor een
                    profielkeuze staan een kijkje kunnen nemen bij diverse
                    bedrijven in de regio.
                  </p>
                  <a
                    id="read-more-link"
                    onClick={() => setIsFullMessageVisible(true)}
                  >
                    Lees meer
                  </a>
                </div>
              )}
              {isFullMessageVisible && (
                <div id="welcome-message">
                  <h1>Welkom</h1>
                  <p>Beste deelnemers aan de Jongeren Bedrijven Dag,</p>
                  <p>
                    Op 5 maart 2024 vindt de 8e editie plaats van de
                    Jongerenbedrijvendag. De Lionsclub Oss heeft aan de basis
                    gestaan van deze dag waarbij scholieren die voor een
                    profielkeuze staan een kijkje kunnen nemen bij diverse
                    bedrijven in de regio.
                  </p>
                  <p>
                    Graag dank ik iedereen die deze dag mogelijk maakt. De
                    scholen in Oss, de bedrijven in Oss en Omgeving maar ook de
                    diverse sponsoren en gemeenten. En zeker niet te vergeten de
                    vele vrijwilligers die de scholieren begeleiden op deze dag.
                  </p>
                  <p>Ik wens iedereen een leuke en leerzame dag toe!</p>
                  <p>
                    <br />
                    Corné Louwers
                    <br />
                    President Lionsclub Oss
                  </p>
                </div>
              )}
            </div>
          </div>
        </header>
        <div className="container content">
          <div>
            <h2>
              <a id="doelstelling">Onze doelstelling</a>
            </h2>
            <p>
              De primaire doelstelling van deze bedrijvendag is tweeledig:
              Jongeren kennis laten maken met beroepen in de echte praktijk door
              een kijkje in de keuken van een echt bedrijf. Bedrijven de deuren
              laten opzetten en jongeren (en docenten) laten zien hoe mooi het
              werken in de sector is en hoe dit specifieke bedrijf haar
              werkzaamheden vorm geeft.
            </p>
            <p>
              Jongeren in de leeftijd van vmbo-2 en havo-3 en vwo-3 staan voor
              het moment om een profiel te kiezen voor de bovenbouw van hun
              opleiding. Deze dag moet bijdragen aan de bevestiging (dus soms
              ook ontkenning) van deze keuze en vormt daarmee een belangrijk
              element.
            </p>
            <p>
              Samen met bijna 115 bedrijven en instellingen laten we zien dat
              werken in Oss en omgeving perspectief biedt voor een mooie
              loopbaan in het bedrijfsleven en dat er een breed aanbod van
              sectoren in Oss en omgeving aanwezig is. Dat er binnen de sectoren
              talloze bedrijven werkzaam zijn waar de leerlingen/studenten
              straks stage kunnen lopen en hun loopbaan kunnen starten. Het is
              van belang dat we als bedrijfsleven samen deze regio op de kaart
              zetten.
            </p>
          </div>
          <div>
            <iframe
              src="https://www.youtube.com/embed/NqxVspmGuPQ?rel=0"
              allow="autoplay; encrypted-media"
              allowFullScreen={true}
              className="video"
              width="400"
              height="220"
              frameBorder="0"
            ></iframe>
          </div>
        </div>
        <div className="companies-wrapper">
          <div className="container content">
            <div>
              <h2>
                <a id="bedrijven">Bedrijven</a>
              </h2>
              <p id="companies-description">
                Aan de aankomende Jongeren Bedrijvendag doen meer dan 100
                bedrijven mee! Uitgebreide informatie over deze bedrijven vind
                je via onderstaande knop.
              </p>
              <a
                href={
                  process.env.NEXT_PUBLIC_JBD_APP_URL + '/login?showcompanies'
                }
                id="companies-button"
                target="_blank"
                rel="noreferrer"
              >
                Bekijk bedrijven
              </a>
            </div>
          </div>
        </div>
        <div className="container content">
          <div>
            <iframe
              src="https://www.youtube.com/embed/CvfuvBFiOzg?rel=0"
              allow="autoplay; encrypted-media"
              allowFullScreen={true}
              className="video"
              width="400"
              height="220"
              frameBorder="0"
            ></iframe>
          </div>
          <div>
            <h2>
              <a id="programma">Het programma</a>
            </h2>
            <p>
              Op de dag zelf zullen leerlingen, ingedeeld in groepen van
              ongeveer 15 personen, drie bedrijven bezoeken. Deze bezoeken zij
              in tijdvakken van anderhalf uur.
            </p>
            <p>
              De dag begint met een openingspraatje op de scholen waarna
              leerlingen op de fiets zullen stappen naar de bedrijfsbezoeken.
              Onder begeleiding van docenten en ouderejaars leerlingen zullen ze
              een kijkje in de keuken krijgen in het bedrijfsleven en opdrachten
              doen die met deze bedrijven te maken hebben.
            </p>
            <p>
              De deelnemende bedrijven organiseren een &quot;doe-opdracht&quot;
              voor de leerlingen en zullen een rondleiding geven door hun
              bedrijf. Meer informatie over hoe dit als bedrijf georganiseerd
              kan worden kun je lezen in onderstaande bestand.
            </p>
            <a
              href="/bedrijfs_instructies.pdf"
              id="instructions-button"
              target="_blank"
            >
              Download instructies
            </a>
          </div>
        </div>
        <div className="container content media">
          <div>
            <h2>
              <a id="media">Media</a>
            </h2>
            <iframe
              src="https://www.youtube.com/embed/QS9GfHiuFEM?rel=0"
              allow="autoplay; encrypted-media"
              allowFullScreen={true}
              className="video"
              width="560"
              height="315"
              frameBorder="0"
            ></iframe>
            <Gallery
              backdropClosesModal={true}
              thumbnailStyle={() => ({
                objectFit: 'cover',
                maxWidth: '100%',
                cursor: 'pointer',
              })}
              enableImageSelection={false}
              images={IMAGES}
            />
          </div>
        </div>
        <footer>
          <div>
            <h3>Contact</h3>
            <dl>
              <dt>
                <strong>TalentenCampus Oss</strong>
              </dt>
              <dt>Nelson Mandelaboulevard 22</dt>
              <dt>5342 CZ&nbsp;&nbsp;Oss</dt>
              <dt>
                <a
                  href="mailto:info@talentencampusoss.nl"
                  target="_blank"
                  rel="noreferrer"
                >
                  info@talentencampusoss.nl
                </a>
              </dt>
            </dl>
            <a href="/privacy.html" target="_blank">
              Privacyverklaring
            </a>
          </div>
          <div>
            <img
              src="/assets/images/logos_footer.png"
              alt="JBD"
              width="373"
              height="75"
            />
          </div>
        </footer>
      </div>
    </>
  );
}

export default Index;
