import { useState } from 'react';
import Gallery from 'react-grid-gallery';

export function Index() {
  const [isFullMessageVisible, setIsFullMessageVisible] =
    useState<boolean>(false);

  return (
    <>
      <div id="page-wrapper">
        <div className="container content">
          <div>
            <h2>
              <a id="privacy">Privacyverklaring</a>
            </h2>
            <p>
              1.1 In het kader van de uitvoering door de Stichting van haar
              werkzaamheden verzamelt zij van medewerkers van de organisatie,
              van begeleiders, beheerders en leerlingen de navolgende
              persoonsgegevens:{' '}
              <ul>
                <li>
                  a) naam, geslacht, paspoortnummer, geboortedatum,
                  nationaliteit,
                </li>
                <li>land van herkomst en geboorteplaats;</li>
                <li>b) adres;</li>
                <li>c) opleiding; </li>
                <li>d) telefoonnummer;</li>
                <li>e) dieetwensen;</li>
                <li>
                  f) aanvullende gegevens die een persoon aan de Stichting heeft
                  verschaft.
                </li>
              </ul>
            </p>

            <p>
              1.2 De persoonsgegevens worden opgeslagen in een beveiligde
              database en zijn alleen ter inzage voor door de Stichting
              geautoriseerde personen en wel als volgt:
              <ul>
                <li>
                  Begeleiders hebben alleen toegang tot de persoonsgegevens van
                  leerlingen die in zijn of haar groep zijn ingedeeld,
                </li>
                <li>
                  Beheerders van de scholen hebben alleen toegang tot de
                  persoonsgegevens van diens leerlingen,
                </li>
                <li>
                  De organisatie van de Jongeren Bedrijvendag en de
                  ontwikkelaars
                </li>
              </ul>
            </p>

            <p>
              1.3 De Stichting bewaart de persoonsgegevens gedurende de termijn
              die redelijkerwijs nodig is voor de doeleinden waarvoor de
              gegevens zijn verzameld of wettelijk is vereist. Indien de
              gegevens personen betreffen die eenmalig bij een activiteit van de
              Stichting zijn betrokken zullen ze binnen redelijke termijn na die
              activiteit worden verwijderd. Indien de gegevens personen
              betreffen die repeterend bij de activiteiten van de Stichting
              betrokken blijven zullen die gegevens worden verwijderd binnen
              redelijke termijn nadat de betrokkenheid van die personen bij die
              activiteiten definitief is geëindigd. De Stichting heeft
              noodzakelijke administratieve en technische maatregelen getroffen
              teneinde de persoonsgegevens te beschermen tegen onbevoegde
              toegang, gebruik, wijziging, verwijdering en het kopiëren van deze
              gegevens.
            </p>

            <p>
              1.4 Een ieder van wie de persoonsgegevens zijn opgeslagen is
              gerechtigd tot het indienen van een schriftelijk verzoek aan de
              Stichting tot:{' '}
              <ul>
                <li>
                  (1) het verschaffen van een kopie van de persoonsgegevens die
                  de Stichting heeft verzameld over die persoon of het
                  verschaffen van informatie over de wijze waarop de Stichting
                  de persoonsgegevens van een betrokken persoon gebruikt, of{' '}
                </li>
                <li>
                  (2) het corrigeren of bijwerken van de persoonsgegevens van de
                  betrokken persoon, of{' '}
                </li>
                <li>
                  (3) het verwijderen van de gegevens of een deel ervan van de
                  betrokken persoon, in welk geval de Stichting die persoon
                  mogelijk niet meer kan laten deelnemen aan haar activiteiten.
                  De Stichting zal zo snel mogelijk op dergelijke verzoeken
                  reageren.
                </li>
              </ul>
            </p>
          </div>
        </div>
        <footer>
          <div>
            <h3>Contact</h3>
            <dl>
              <dt>
                <strong>TalentenCampus Oss</strong>
              </dt>
              <dt>Nelson Mandelaboulevard 22</dt>
              <dt>5342 CZ&nbsp;&nbsp;Oss</dt>
              <dt>
                <a
                  href="mailto:info@talentencampusoss.nl"
                  target="_blank"
                  rel="noreferrer"
                >
                  info@talentencampusoss.nl
                </a>
              </dt>
            </dl>
          </div>
          <div>
            <img
              src="/assets/images/logos_footer.png"
              alt="JBD"
              width="373"
              height="75"
            />
          </div>
        </footer>
      </div>
    </>
  );
}

export default Index;
