import { Component, OnInit } from '@angular/core';
import {ActivatedRoute} from '@angular/router';
import {NotificationsService} from 'angular2-notifications';
import * as Color from 'color';
import {FormControl, FormGroup, Validators} from '@angular/forms';
import {PasswordValidators} from '@app/shared/password.validator';
import {HttpClient} from '@angular/common/http';
import {markFormGroupTouched} from '@app/shared/form-group';
import { AuthService } from '../shared/auth.service';
import { LoginResponseAuthToken, LoginResponseUser } from '../shared/auth-data.service';

@Component({
  selector: 'app-account',
  templateUrl: './account.component.html',
  styleUrls: ['./account.component.scss']
})
export class AccountComponent implements OnInit {
  color: Color;
  user: LoginResponseUser = null;
  passwordForm: FormGroup = null;
  personForm: FormGroup = null;

  authToken: LoginResponseAuthToken;
  permissions: any;

  constructor(private toast: NotificationsService,
              private authService: AuthService,
              private http: HttpClient) { }

  ngOnInit() {

  }

  async init() {
    const auth = await this.authService.getStatus();
    this.color = /* auth.selection.organisation ? auth.selection.organisation.primaryColor : */ Color("#008cd6");
    this.user = auth.user;
    this.authToken = auth.authToken;
    this.permissions = auth.permissions;
    if (this.user) {
      this.passwordForm = new FormGroup({
        oldPassword: new FormControl("", Validators.required),
        password: new FormControl("", Validators.required),
        passwordRepeat: new FormControl("", Validators.required)
      }, [PasswordValidators.matchPassword]);

      this.personForm = new FormGroup({
        firstName: new FormControl(this.user.person ? this.user.person.firstName : "", Validators.required),
        insertion: new FormControl(this.user.person ? this.user.person.insertion : ""),
        lastName: new FormControl(this.user.person ? this.user.person.lastName : "", Validators.required),
      });
    }
  }

  changePassword() {
    markFormGroupTouched(this.passwordForm);

    if (this.passwordForm.valid) {
      this.http.put(`/users/${this.user.id}`, this.passwordForm.value).subscribe(
        () => this.toast.success("Nieuw wachtwoord succesvol ingesteld"),
        (error) => this.toast.error( "Er ging iets mis.",
          error.error.message ? "Huidige wachtwoord incorrect." : "")
      );
    }
  }

  updatePerson() {
    markFormGroupTouched(this.personForm);

    if (this.personForm.valid) {
      this.http.put(`/users/${this.user.id}`, {person: this.personForm.value}).subscribe(
        (user: LoginResponseUser) => {
          this.toast.success("Gegevens succesvol aangepast");
          this.init();
        },
        (error) => this.toast.error( "Er ging iets mis.")
      );
    }
  }

  logout() {
    this.authService.logout();
  }
}
