import { NgModule } from "@angular/core";
import { Routes, RouterModule } from "@angular/router";
import { extract, Route } from "@app/core";
import { CompaniesUnauthedDetailComponent } from "@app/companies/unauthed-detail/companies-unauthed-detail.component";
import { OrganisationsListComponent } from "@app/organisations/list/organisations-list.component";
import { OrganisationLocationsComponent } from "@app/organisations/locations/organisation-locations.component";
import { OrganisationsMembersComponent } from "@app/organisations/members/organisations-members.component";
import { MemberDetailComponent } from "@app/shared/member-detail/member-detail.component";
import { CategoriesComponent } from "@app/categories/categories.component";
import { MessagesComponent } from "@app/organisations/messages/messages.component";
import { FeedbackComponent } from "@app/organisations/feedback/feedback.component";
import { OrganisationWrapperComponent } from "@app/organisations/organisation-wrapper/organisation-wrapper.component";
import { SchoolsListComponent } from "@app/schools/list/schools-list.component";
import { SchoolDetailComponent } from "@app/schools/detail/school-detail.component";
import { GroupsComponent } from "@app/schools/groups/groups.component";
import { GroupDetailComponent } from "@app/schools/groups/detail/group-detail.component";
import { MembersComponent } from "@app/schools/members/members.component";
import { ImporterComponent } from "@app/schools/importer/importer.component";
import { BatchesComponent } from "@app/schools/batches/batches.component";
import { EventsComponent } from "@app/events/events.component";
import { EventDetailComponent } from "@app/events/detail/event-detail.component";
import { EventDetailPlanningComponent } from "@app/events/planning/event-detail-planning.component";
import { EventCompaniesComponent } from "@app/events/companies/event-companies.component";
import { CompaniesListComponent } from "@app/companies/list/companies-list.component";
import { CompanyDetailComponent } from "@app/companies/detail/company-detail.component";
import { AccountComponent } from "@app/account/account.component";
import { SchoolWrapperComponent } from "@app/schools/school-wrapper/school-wrapper.component";
import { EventWrapperComponent } from "@app/events/event-wrapper/event-wrapper.component";
import { TemplatesComponent } from "./organisations/templates/templates.component";
import { CommunicationCenterComponent } from "./organisations/communication-center/communication-center.component";
import { CompanyWrapperComponent } from "./companies/company-wrapper/company-wrapper.component";
import { EmailBatchComponent } from "./organisations/communication-center/email-batch/email-batch.component";
import { EmailComposerComponent } from "./organisations/communication-center/email-composer/email-composer.component";

const routes: Routes = [
  Route.withShell([
    { path: "", pathMatch: "full", redirectTo: "organisaties" },
    {
      path: "organisaties",
      data: { title: extract("Organisaties") },
      children: [
        { path: "", component: OrganisationsListComponent, data: { title: extract("Organisaties") } },
        {
          path: ":organisationId",
          component: OrganisationWrapperComponent,
          children: [
            // Events
            {
              path: "evenementen",
              data: { title: extract("Organisaties > Evenementen") },
              children: [
                { path: "", component: EventsComponent, data: { title: extract("Organisaties > Evenementen") } },
                {
                  path: ":eventId",
                  component: EventWrapperComponent,
                  data: { title: extract("Organisaties > Evenementen > :eventId") },
                  children: [
                    {
                      path: "",
                      component: EventDetailComponent,
                      data: { title: extract("Organisaties > Evenementen > Aanpassen") }
                    },
                    {
                      path: "planning",
                      component: EventDetailPlanningComponent,
                      data: { title: extract("Organisaties > Evenementen > Aanpassen") }
                    },
                    {
                      path: "bedrijven",
                      component: EventCompaniesComponent,
                      data: { title: extract("Organisaties > Evenementen > Bedrijven") }
                    }
                  ]
                }
              ]
            },
            // Locaties
            {
              path: "locaties",
              component: OrganisationLocationsComponent,
              data: { title: extract("Locaties") }
            },
            // Accounts
            {
              path: "accounts",
              component: OrganisationsMembersComponent,
              data: { title: extract("Accounts") }
            },
            {
              path: "accounts/:memberId",
              component: MemberDetailComponent,
              data: { type: "organisationMember", title: extract("Accounts > Detail") }
            },
            {
              path: "categorieen",
              component: CategoriesComponent,
              data: { title: extract("Categorieën") }
            },
            {
              path: "push-berichten",
              component: MessagesComponent,
              data: { title: extract("Push-berichten") }
            },
            {
              path: "communicatie",
              component: CommunicationCenterComponent,
              data: { title: extract("Communicatiecentrum"), filter: "organisation" },
              children: [
                {
                  path: "nieuw",
                  component: EmailComposerComponent
                },
                {
                  path: ":batchId",
                  component: EmailBatchComponent
                }
              ]
            },
            {
              path: "templates",
              component: TemplatesComponent,
              data: { title: extract("Templates aanpassen") }
            },
            {
              path: "feedback",
              component: FeedbackComponent,
              data: { title: extract("Feedback") }
            },
            // Scholen
            {
              path: "scholen",
              data: { title: extract("Scholen") },
              children: [
                { path: "", component: SchoolsListComponent, data: { title: extract("Scholen") } },
                {
                  path: ":schoolId",
                  component: SchoolWrapperComponent,
                  data: { title: extract("Scholen >") },
                  children: [
                    { path: "", component: SchoolDetailComponent, data: { title: extract("Scholen > ") } },
                    { path: "groepen", component: GroupsComponent, data: { title: extract("Scholen > Groepen") } },
                    {
                      path: "groepen/:groupId",
                      component: GroupDetailComponent,
                      data: { title: extract("Scholen > Groepen >") }
                    },
                    { path: "accounts", component: MembersComponent, data: { title: extract("Scholen > Accounts") } },
                    {
                      path: "accounts/:memberId",
                      component: MemberDetailComponent,
                      data: { type: "schoolMember", title: extract("Scholen > Accounts > Detail") }
                    },
                    {
                      path: "importeren",
                      component: ImporterComponent,
                      data: { title: extract("Scholen > Importeren") }
                    },
                    { path: "batches", component: BatchesComponent, data: { title: extract("Scholen > Batches") } },
                    {
                      path: "communicatie",
                      component: CommunicationCenterComponent,
                      data: { title: extract("Communicatiecentrum"), filter: "school" },
                      children: [
                        {
                          path: "nieuw",
                          component: EmailComposerComponent
                        },
                        {
                          path: ":batchId",
                          component: EmailBatchComponent
                        }
                      ]
                    }
                  ]
                }
              ]
            },
            // Bedrijven
            {
              path: "bedrijven",
              data: { title: extract("Bedrijven") },
              children: [
                { path: "", component: CompaniesListComponent, data: { title: extract("Bedrijven") } },
                {
                  path: "nieuw",
                  component: CompanyDetailComponent,
                  data: { title: extract("Bedrijven > Nieuw"), isNew: true }
                },
                {
                  path: ":companyId",
                  component: CompanyWrapperComponent,
                  data: { title: extract("Bedrijven >") },
                  children: [
                    { path: "", component: CompanyDetailComponent },
                    {
                      path: "communicatie",
                      component: CommunicationCenterComponent,
                      data: { title: extract("Communicatiecentrum"), filter: "company" },
                      children: [
                        {
                          path: "nieuw",
                          component: EmailComposerComponent
                        },
                        {
                          path: ":batchId",
                          component: EmailBatchComponent
                        }
                      ]
                    }
                  ]
                }
              ]
            }
          ]
        }
      ]
    },
    { path: "account", component: AccountComponent, data: { title: extract("Uw account") } }
  ])
];

@NgModule({
  imports: [RouterModule.forRoot(routes)],
  exports: [RouterModule],
  providers: []
})
export class AppRoutingModule {}
