import { BrowserModule } from "@angular/platform-browser";
import { BrowserAnimationsModule } from "@angular/platform-browser/animations";
import { NgModule } from "@angular/core";
import { FormsModule } from "@angular/forms";
import { HttpClientModule } from "@angular/common/http";
import { TranslateModule } from "@ngx-translate/core";
import { NgbModule } from "@ng-bootstrap/ng-bootstrap";

import { CoreModule, extract } from "@app/core";
import { SharedModule } from "@app/shared";
import { OrganisationsModule } from "./organisations/organisations.module";
import { SchoolsModule } from "./schools/schools.module";
import { AppComponent } from "./app.component";
import { AppRoutingModule } from "./app-routing.module";
import { CompaniesModule } from "@app/companies/companies.module";
import { AuthModule } from "@app/auth/auth.module";
import { OrganisationWrapperComponent } from "./organisations/organisation-wrapper/organisation-wrapper.component";

import { SimpleNotificationsModule } from "angular2-notifications";
import { CategoriesModule } from "@app/categories/categories.module";
import { AccountModule } from "@app/account/account.module";
import { EventsModule } from "@app/events/events.module";
import { ImageUploadModule } from "angular2-image-upload";
import { DragulaModule } from "ng2-dragula";
import { NgxLinkifyjsModule } from "ngx-linkifyjs";
import { SchoolWrapperComponent } from "@app/schools/school-wrapper/school-wrapper.component";
import { EventWrapperComponent } from "@app/events/event-wrapper/event-wrapper.component";
import { RouterModule } from "@angular/router";
import { CompaniesUnauthedDetailComponent } from "@app/companies/unauthed-detail/companies-unauthed-detail.component";
import { CompanyWrapperComponent } from "@app/companies/company-wrapper/company-wrapper.component";

const fallbackAndExtraRoutes = RouterModule.forRoot([
  // Fallback when no prior route is matched
  {
    path: "catalogus/:id/:token",
    component: CompaniesUnauthedDetailComponent,
    data: { title: extract("Bedrijf bekijken") }
  },
  { path: "**", redirectTo: "/organisaties", pathMatch: "full" }
]);

@NgModule({
  declarations: [
    AppComponent,
    OrganisationWrapperComponent,
    SchoolWrapperComponent,
    EventWrapperComponent,
    CompanyWrapperComponent
  ],
  imports: [
    BrowserModule,
    FormsModule,
    HttpClientModule,
    TranslateModule.forRoot(),
    NgbModule,
    CoreModule,
    SharedModule,
    OrganisationsModule,
    SchoolsModule,
    CategoriesModule,
    CompaniesModule,
    EventsModule,
    AccountModule,
    AppRoutingModule,
    AuthModule,
    fallbackAndExtraRoutes,
    DragulaModule.forRoot(),
    ImageUploadModule.forRoot(),
    NgxLinkifyjsModule.forRoot(),
    BrowserAnimationsModule,
    SimpleNotificationsModule.forRoot()
  ],
  providers: [],
  bootstrap: [AppComponent]
})
export class AppModule {
  constructor() {}
}
