import {NgModule} from '@angular/core';
import {RouterModule, Routes, UrlSegment} from '@angular/router';

import {extract, Route} from '@app/core';
import {LoginComponent} from '@app/auth/login/login.component';
import {ForgotPasswordComponent} from '@app/auth/forgot-password/forgot-password.component';
import {ResetPasswordComponent} from '@app/auth/reset-password/reset-password.component';
import {EmailVerifiedComponent} from '@app/auth/email-verified/email-verified.component';

const authRoutes = [
  'login',
  'forgot-password',
  'register'
];

const routes: Routes = Route.withAuthShell([
  {path: 'login', component: LoginComponent, data: {title: extract('Aanmelden')}},
  {path: 'wachtwoord-vergeten', component: ForgotPasswordComponent, data: {title: extract('Wachtwoord vergeten')}},
  {path: 'email-bevestigen', component: EmailVerifiedComponent, data: {title: extract('E-mailadres bevestigen')}},
  {path: 'wachtwoord-herstellen', component: ResetPasswordComponent, data: {title: extract('Wachtwoord herstellen')}}
]);

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
  providers: []
})
export class AuthRoutingModule {
}
