import { NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { ReactiveFormsModule } from '@angular/forms';
import { TranslateModule } from '@ngx-translate/core';
import { NgbModule } from '@ng-bootstrap/ng-bootstrap';

import { AuthRoutingModule } from './auth-routing.module';
import { AuthComponent } from './auth.component';
import {SharedModule} from '@app/shared';
import {LoginComponent} from '@app/auth/login/login.component';
import { ForgotPasswordComponent } from './forgot-password/forgot-password.component';
import {ResetPasswordComponent} from '@app/auth/reset-password/reset-password.component';
import { EmailVerifiedComponent } from './email-verified/email-verified.component';

@NgModule({
  imports: [
    CommonModule,
    SharedModule,
    ReactiveFormsModule,
    TranslateModule,
    NgbModule,
    AuthRoutingModule
  ],
  declarations: [
    LoginComponent,
    AuthComponent,
    ResetPasswordComponent,
    ForgotPasswordComponent,
    EmailVerifiedComponent
  ]
})
export class AuthModule { }
