import {Component, OnInit} from '@angular/core';
import {NotificationsService} from 'angular2-notifications';
import {HttpClient} from '@angular/common/http';
import {ActivatedRoute} from '@angular/router';

@Component({
  selector: 'app-email-verified',
  templateUrl: './email-verified.component.html',
  styleUrls: ['./email-verified.component.scss']
})
export class EmailVerifiedComponent implements OnInit {

  constructor(private toast: NotificationsService, private route: ActivatedRoute, private http: HttpClient) {
  }

  ngOnInit() {
    const {user, token} = this.route.snapshot.queryParams;

    this.http.post('/auth/email-verify/confirm', {userId: user, token}).subscribe(response => {
      this.toast.success('', 'E-mailadres geverifieerd!');
    }, error => {
      this.toast.error('Er is een fout opgetreden.', error.error.message);
    });
  }

}
