import { Component, OnInit } from '@angular/core';
import {FormControl, FormGroup, Validators} from '@angular/forms';
import {HttpClient} from '@angular/common/http';
import {NotificationsService} from 'angular2-notifications';
import {markFormGroupTouched} from '@app/shared/form-group';

@Component({
  selector: 'app-forgot-password',
  templateUrl: './forgot-password.component.html',
  styleUrls: ['./forgot-password.component.scss']
})
export class ForgotPasswordComponent implements OnInit {
  forgotForm: FormGroup;

  constructor(private http: HttpClient, private toast: NotificationsService) { }

  ngOnInit() {
    this.forgotForm = new FormGroup({
      username: new FormControl('', Validators.required)
    });
  }

  resetPassword() {
    markFormGroupTouched(this.forgotForm);

    if (this.forgotForm.valid) {
      this.http.post("/auth/password-reset", this.forgotForm.value).subscribe(() => {
        this.toast.success("E-mail verzonden.", "Daar vind je instructies voor wachtwoordherstel.");
      }, error => {
        if (error.error.message === "email not verified") {
          this.http.post("/auth/email-verify", this.forgotForm.value).subscribe(() => {
            this.toast.error("E-mailadres nog niet geverifiēerd.", "Er is een nieuwe activatiemail verstuurd.");
          });
        } else {
          this.toast.error("Er is een fout opgetreden.", error.error.message);
        }
      });
    }
  }
}
