import { Component, OnInit } from '@angular/core';
import {FormControl, Validators, FormGroup} from '@angular/forms';

import { environment } from '@env/environment';

import {Observable} from 'rxjs/index';
import {markFormGroupTouched} from '@app/shared/form-group';
import {NotificationsService} from 'angular2-notifications';
import { AuthService } from '../../shared/auth.service';
import { Router } from '@angular/router';

@Component({
  selector: 'app-login',
  templateUrl: './login.component.html',
  styleUrls: ['./login.component.scss']
})
export class LoginComponent implements OnInit {
  authError: Error;
  version: string = environment.version;
  loginForm: FormGroup;

  constructor(private authService: AuthService,
              private router: Router,
              private toast: NotificationsService) {
    this.createForm();
  }

  ngOnInit() {
    const sessionExpired = window.localStorage.getItem('sessionExpired');
    if (sessionExpired) {
      this.toast.error("Sessie verlopen", "Meld u opnieuw aan, alstublieft.");
      window.localStorage.removeItem("sessionExpired");
    }
  }

  async login() {
    markFormGroupTouched(this.loginForm);

    if (this.loginForm.valid) {
      try {
        await this.authService.login(this.loginForm.value.username, this.loginForm.value.password);
        this.router.navigate(["/"]);
      } catch (err) {
        this.authError = err;
        console.log(err);
      }
    } else {
    }
  }

  private createForm() {
    this.loginForm = new FormGroup({
      username: new FormControl("", [Validators.required]),
      password: new FormControl("", Validators.required)
    });
  }

}
