import { Component, OnInit } from '@angular/core';
import {FormControl, FormGroup, Validators} from '@angular/forms';
import {PasswordValidators} from '@app/shared/password.validator';
import {HttpClient} from '@angular/common/http';
import {NotificationsService} from 'angular2-notifications';
import {ActivatedRoute, Router} from '@angular/router';
import {markFormGroupTouched} from '@app/shared/form-group';

@Component({
  selector: 'app-reset-password',
  templateUrl: './reset-password.component.html',
  styleUrls: ['./reset-password.component.scss']
})
export class ResetPasswordComponent implements OnInit {
  recoveryForm: FormGroup;

  constructor(private http: HttpClient, private toast: NotificationsService, private router: Router, private route: ActivatedRoute) { }

  ngOnInit() {
    const {user, token} = this.route.snapshot.queryParams;

    this.recoveryForm = new FormGroup({
      userId: new FormControl(user, Validators.required),
      token: new FormControl(token, Validators.required),
      password: new FormControl('', Validators.required),
      passwordRepeat: new FormControl('', Validators.required)
    }, [PasswordValidators.matchPassword]);
  }

  resetPassword() {
    markFormGroupTouched(this.recoveryForm);
    if (this.recoveryForm.valid) {
      this.http.post("/auth/password-reset/confirm", this.recoveryForm.value).subscribe(response => {
        this.toast.success("Wachtwoord succesvol opnieuw ingesteld.", "Je kunt nu aanmelden met deze gegevens.");
        this.router.navigate(["/login"]);
      }, error => {
        this.toast.error("Er is een fout opgetreden.", error.error.message);
      });
    }
  }
}
