import {Injectable} from '@angular/core';
import {HttpClient} from '@angular/common/http';

import {Observable} from 'rxjs';

import {map} from 'rxjs/operators';

import {Category} from '@app/shared/models/category.model';

@Injectable()
export class CategoriesDataService {
  categories: { [organisationId: string]: Category[] } = {};

  constructor(private http: HttpClient) { }

  getAllForOrganisation(organisationId: string): Observable<Category[]> {
    return this.http.get<Category[]>(`/organisations/${organisationId}/categories`).pipe(
      map((entities) => entities.sort((a, b) => (a.name.toLowerCase() < b.name.toLowerCase() ? -1 : 1)))
    );
  }

  addToOrganisation(organisationId: string, entity: Category): Observable<Category> {
    return this.http.post<Category>(`/organisations/${organisationId}/categories`, entity);
  }

  updateInOrganisation(organisationId: string, entity: Partial<Category>) {
    return this.http.put<Category>(`/organisations/${organisationId}/categories/${entity.id}`, entity);
  }

  deleteFromOrganisation(organisationId: string, entityId: string): Observable<void> {
    return this.http.delete<void>(`/organisations/${organisationId}/categories/${entityId}`);
  }
}
