import {Component, OnInit} from '@angular/core';
import {Validators} from '@angular/forms';
import {NgbModal} from '@ng-bootstrap/ng-bootstrap';
import {CrudComponent} from '@app/shared/crud.component';
import {FormModalComponent, FormModalInputOptions} from '@app/shared/form-modal/form-modal.component';
import {Category} from '@app/shared/models/category.model';
import {Title} from '@angular/platform-browser';
import {CategoriesDataService} from '@app/categories/categories-data.service';
import {OrganisationsDataService} from "@app/organisations/organisations-data.service";
import {Organisation} from "@app/shared/models/organisation.model";
import { tap } from 'rxjs/operators';

@Component({
  selector: 'app-category',
  templateUrl: './categories.component.html',
  styleUrls: ['./categories.component.scss']
})
export class CategoriesComponent extends CrudComponent<Category> implements OnInit {
  organisation: Organisation = null;

  constructor(private modal: NgbModal, private organisationsService: OrganisationsDataService,
              private categoriesService: CategoriesDataService,
              private title: Title) {
    super();
    super.initialize(modal);
  }

  ngOnInit() {
    this.organisation = this.organisationsService.currentOrganisation;
    this.title.setTitle(`Organisaties > ${this.organisation.name} > Categorieën`);
    this.loadCategories();
  }

  loadCategories() {
    this.categoriesService.getAllForOrganisation(this.organisation.id).subscribe(cats => this.entities = cats);
  }

  rowClicked(event: any) {
    const category = event.selected[0] as Category;

    const modalRef = this.modalService.open(FormModalComponent);
    const component = modalRef.componentInstance as FormModalComponent;
    component.title = "Categorie aanpassen";
    component.confirmLabel = "Aanpassen";
    component.fields = [
      new FormModalInputOptions("name", "Naam van de categorie",
        "text", category.name, [Validators.required]),
      new FormModalInputOptions("color", "Kleur",
        "color", category.color, [Validators.required])
    ];

    component.callback = (result) => {
      return this.categoriesService.updateInOrganisation(this.organisation.id, {...result, id: category.id}).pipe(tap(() => this.loadCategories()));
    };
  }

  deleteEntity(entity: Category) {
    this.categoriesService.deleteFromOrganisation(this.organisation.id, entity.id).subscribe(() => {
      this.loadCategories();
    });
  }

  newPressed() {
    const modalRef = this.modalService.open(FormModalComponent);
    const component = modalRef.componentInstance as FormModalComponent;
    component.callback = (result) => {
      return this.categoriesService.addToOrganisation(this.organisation.id, result).pipe(tap(() => this.loadCategories()));
    };
    component.title = "Nieuwe categorie toevoegen";
    component.confirmLabel = "Toevoegen";
    component.fields = [
      new FormModalInputOptions("name", "Naam van de categorie",
        "text", "", [Validators.required]),
      new FormModalInputOptions("color", "Kleur",
        "color", "#008cd6", [Validators.required])
    ];
  }
}
