import { Component, OnInit } from "@angular/core";
import { ActivatedRoute } from "@angular/router";
import { CompaniesDataService } from "@app/companies/companies-data.service";
import { Company } from "@app/shared/models/company.model";
import { OrganisationsDataService } from "@app/organisations/organisations-data.service";
import { Title } from "@angular/platform-browser";

@Component({
  selector: "app-company-wrapper",
  templateUrl: "./company-wrapper.component.html",
  styleUrls: ["./company-wrapper.component.scss"]
})
export class CompanyWrapperComponent implements OnInit {
  lastLoadedCompanyId = "";
  lastLoadedCompany: Company = null;

  constructor(
    private route: ActivatedRoute,
    private title: Title,
    private companyService: CompaniesDataService,
    private organisationsService: OrganisationsDataService
  ) {}

  ngOnInit() {
    this.route.params.subscribe(params => {
      if (params.companyId !== this.lastLoadedCompanyId) {
        this.lastLoadedCompanyId = params.companyId;
        this.companyService
          .getByIdForOrganisation(this.organisationsService.currentOrganisation.id, params.companyId)
          .subscribe((company: Company) => {
            this.companyService.currentCompany = company;
            this.lastLoadedCompany = company;
            this.title.setTitle(`Bedrijven > ${company.name}`);
          });
      }
    });
  }
}
