import {Component, OnInit} from '@angular/core';
import {Validators} from '@angular/forms';
import {NgbModal} from '@ng-bootstrap/ng-bootstrap';
import {CrudComponent} from '@app/shared/crud.component';
import {Company} from '@app/shared/models/company.model';
import {FormModalComponent, FormModalInputOptions} from '@app/shared/form-modal/form-modal.component';
import {CompaniesDataService} from '@app/companies/companies-data.service';
import {NotificationsService} from 'angular2-notifications';
import {CategoriesDataService} from '@app/categories/categories-data.service';
import {Category} from '@app/shared/models/category.model';
import {Router} from '@angular/router';
import {first} from 'rxjs/operators';
import {OrganisationsDataService} from "@app/organisations/organisations-data.service";
import {Organisation} from "@app/shared/models/organisation.model";

@Component({
  selector: 'app-companies-list',
  templateUrl: './companies-list.component.html',
  styleUrls: ['./companies-list.component.scss']
})
export class CompaniesListComponent extends CrudComponent<Company> implements OnInit {
  categories: Category[] = [];
  organisation: Organisation = null;

  constructor(private organisationsService: OrganisationsDataService,
              private companiesService: CompaniesDataService,
              private categoriesService: CategoriesDataService,
              private toast: NotificationsService,
              modal: NgbModal,
              private router: Router) {
    super();
    super.initialize(modal);
  }

  ngOnInit() {
    setTimeout(() => {
      this.table.messages.totalMessage = "bedrijven";
    });

    this.organisation = this.organisationsService.currentOrganisation;
    this.companiesService.getAllForOrganisation(this.organisation.id)
      .subscribe(companies => {
        this.entities = companies;
        this.temp = companies;
      });

    this.categoriesService.getAllForOrganisation(this.organisation.id).subscribe((categories) => {
      this.categories = categories;
    });
  }

  rowClicked(e: any) {
    this.router.navigate(["/organisaties", this.organisation.id, "bedrijven", e.selected[0].id]);
  }

  newPressed() {
    const modalRef = this.modalService.open(FormModalComponent);
    const component = modalRef.componentInstance as FormModalComponent;
    component.title = 'Nieuw bedrijf toevoegen';
    component.confirmLabel = 'Toevoegen';
    component.fields = [
      new FormModalInputOptions('name', 'Bedrijfsnaam', 'text', '', [Validators.required]),
    ];
    component.callback = (result: any) => this.companiesService.addToOrganisation(this.organisation.id, result).pipe(first());
    component.onSuccess = (company: Company) => {
      this.router.navigate(["/organisaties", this.organisation.id, "bedrijven", company.id]);
    };
  }

  existingPressed() {
    const modalRef = this.modalService.open(FormModalComponent);
    const component = modalRef.componentInstance as FormModalComponent;
    component.title = 'Bestaand bedrijf toevoegen';
    component.description = 'Vraag het bedrijf om de unieke koppelcode en vul deze hieronder in.';
    component.confirmLabel = 'Toevoegen';
    component.fields = [
      new FormModalInputOptions(
        'companyLinkingCode',
        'Unieke koppelcode',
        'text',
        '',
        [Validators.required]),
    ];

    component.callback = (result: any) => this.companiesService.addToOrganisation(this.organisation.id, result);
    component.onSuccess = (company: Company) => {
      this.toast.success('Bedrijf succesvol gekoppeld.');
      this.router.navigate(["/organisaties", this.organisation.id, "bedrijven", company.id]);
      this.companiesService.getAllForOrganisation(this.organisation.id)
        .subscribe(companies => {
          this.entities = companies;
          this.temp = companies;
        });
    };
    component.onError = () => {
      this.toast.error('Er ging iets mis.');
    };
  }

  deleteEntity(entity: Company) {
    this.companiesService.deleteFromOrganisation(this.organisation.id, entity.id).subscribe(() => {
      this.toast.success("Bedrijf verwijderd.");
      this.companiesService.getAllForOrganisation(this.organisation.id)
        .subscribe(companies => {
          this.entities = companies;
          this.temp = companies;
        });
    });
  }
}
