import {HttpEvent, HttpHandler, HttpInterceptor, HttpRequest} from '@angular/common/http';
import {Observable} from 'rxjs/index';
import {Injectable} from '@angular/core';
import { AuthDataService } from '../../shared/auth-data.service';

@Injectable()
export class AuthInterceptor implements HttpInterceptor {
  constructor(private authDataService: AuthDataService) {
  }

  intercept(req: HttpRequest<any>, next: HttpHandler): Observable<HttpEvent<any>> {
    if (this.authDataService.authToken !== null) {
      const headers = {
        Authorization: `Bearer ${this.authDataService.authToken.token}`
      };

      return next.handle(req.clone({
        setHeaders: headers
      }));
    } else {
      return next.handle(req);
    }
  }
}
